@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.LinkedStorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Linked storage accounts top level resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### LinkedStorageAccountsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedStorageAccount = new AzureNative.OperationalInsights.LinkedStorageAccount("linkedStorageAccount", new()
 *     {
 *         DataSourceType = "CustomLogs",
 *         ResourceGroupName = "mms-eus",
 *         StorageAccountIds = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA",
 *             "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB",
 *         },
 *         WorkspaceName = "testLinkStorageAccountsWS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewLinkedStorageAccount(ctx, "linkedStorageAccount", &operationalinsights.LinkedStorageAccountArgs{
 * 			DataSourceType:    pulumi.String("CustomLogs"),
 * 			ResourceGroupName: pulumi.String("mms-eus"),
 * 			StorageAccountIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB"),
 * 			},
 * 			WorkspaceName: pulumi.String("testLinkStorageAccountsWS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.LinkedStorageAccount;
 * import com.pulumi.azurenative.operationalinsights.LinkedStorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedStorageAccount = new LinkedStorageAccount("linkedStorageAccount", LinkedStorageAccountArgs.builder()
 *             .dataSourceType("CustomLogs")
 *             .resourceGroupName("mms-eus")
 *             .storageAccountIds(
 *                 "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA",
 *                 "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB")
 *             .workspaceName("testLinkStorageAccountsWS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:LinkedStorageAccount CustomLogs /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedStorageAccounts/{dataSourceType}
 * ```
 * @property dataSourceType Linked storage accounts type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageAccountIds Linked storage accounts resources ids.
 * @property workspaceName The name of the workspace.
 */
public data class LinkedStorageAccountArgs(
    public val dataSourceType: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountIds: Output<List<String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.LinkedStorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.LinkedStorageAccountArgs =
        com.pulumi.azurenative.operationalinsights.LinkedStorageAccountArgs.builder()
            .dataSourceType(dataSourceType?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountIds(storageAccountIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedStorageAccountArgs].
 */
@PulumiTagMarker
public class LinkedStorageAccountArgsBuilder internal constructor() {
    private var dataSourceType: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountIds: Output<List<String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Linked storage accounts type.
     */
    @JvmName("dxjvbqtknwfrvcsc")
    public suspend fun dataSourceType(`value`: Output<String>) {
        this.dataSourceType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mdyskiomteyxmpqc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Linked storage accounts resources ids.
     */
    @JvmName("mrnutrkeealdqpgj")
    public suspend fun storageAccountIds(`value`: Output<List<String>>) {
        this.storageAccountIds = value
    }

    @JvmName("xleifliyvglhejmh")
    public suspend fun storageAccountIds(vararg values: Output<String>) {
        this.storageAccountIds = Output.all(values.asList())
    }

    /**
     * @param values Linked storage accounts resources ids.
     */
    @JvmName("uablcrmkoxfekwxg")
    public suspend fun storageAccountIds(values: List<Output<String>>) {
        this.storageAccountIds = Output.all(values)
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ehtjbtpwbrocwbtg")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Linked storage accounts type.
     */
    @JvmName("bncrugrnxeqkrobc")
    public suspend fun dataSourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("esgyyicbotxctdsm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Linked storage accounts resources ids.
     */
    @JvmName("ramdaxtjhciyaqcp")
    public suspend fun storageAccountIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountIds = mapped
    }

    /**
     * @param values Linked storage accounts resources ids.
     */
    @JvmName("bdibicmyxathbxby")
    public suspend fun storageAccountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountIds = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("usrirafhaavpvgjq")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): LinkedStorageAccountArgs = LinkedStorageAccountArgs(
        dataSourceType = dataSourceType,
        resourceGroupName = resourceGroupName,
        storageAccountIds = storageAccountIds,
        workspaceName = workspaceName,
    )
}
