@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.SavedSearchArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.TagArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.TagArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Value object for saved search results.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2015-03-20.
 * ## Example Usage
 * ### SavedSearchCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var savedSearch = new AzureNative.OperationalInsights.SavedSearch("savedSearch", new()
 *     {
 *         Category = "Saved Search Test Category",
 *         DisplayName = "Create or Update Saved Search Test",
 *         FunctionAlias = "heartbeat_func",
 *         FunctionParameters = "a:int=1",
 *         Query = "Heartbeat | summarize Count() by Computer | take a",
 *         ResourceGroupName = "TestRG",
 *         SavedSearchId = "00000000-0000-0000-0000-00000000000",
 *         Tags = new[]
 *         {
 *             new AzureNative.OperationalInsights.Inputs.TagArgs
 *             {
 *                 Name = "Group",
 *                 Value = "Computer",
 *             },
 *         },
 *         Version = 2,
 *         WorkspaceName = "TestWS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewSavedSearch(ctx, "savedSearch", &operationalinsights.SavedSearchArgs{
 * 			Category:           pulumi.String("Saved Search Test Category"),
 * 			DisplayName:        pulumi.String("Create or Update Saved Search Test"),
 * 			FunctionAlias:      pulumi.String("heartbeat_func"),
 * 			FunctionParameters: pulumi.String("a:int=1"),
 * 			Query:              pulumi.String("Heartbeat | summarize Count() by Computer | take a"),
 * 			ResourceGroupName:  pulumi.String("TestRG"),
 * 			SavedSearchId:      pulumi.String("00000000-0000-0000-0000-00000000000"),
 * 			Tags: []operationalinsights.TagArgs{
 * 				{
 * 					Name:  pulumi.String("Group"),
 * 					Value: pulumi.String("Computer"),
 * 				},
 * 			},
 * 			Version:       pulumi.Float64(2),
 * 			WorkspaceName: pulumi.String("TestWS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.SavedSearch;
 * import com.pulumi.azurenative.operationalinsights.SavedSearchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var savedSearch = new SavedSearch("savedSearch", SavedSearchArgs.builder()
 *             .category("Saved Search Test Category")
 *             .displayName("Create or Update Saved Search Test")
 *             .functionAlias("heartbeat_func")
 *             .functionParameters("a:int=1")
 *             .query("Heartbeat | summarize Count() by Computer | take a")
 *             .resourceGroupName("TestRG")
 *             .savedSearchId("00000000-0000-0000-0000-00000000000")
 *             .tags(Map.ofEntries(
 *                 Map.entry("name", "Group"),
 *                 Map.entry("value", "Computer")
 *             ))
 *             .version(2)
 *             .workspaceName("TestWS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:SavedSearch myresource1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchId}
 * ```
 * @property category The category of the saved search. This helps the user to find a saved search faster.
 * @property displayName Saved search display name.
 * @property functionAlias The function alias if query serves as a function.
 * @property functionParameters The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2 = default_value2'. For more examples and proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
 * @property query The query expression for the saved search.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property savedSearchId The id of the saved search.
 * @property tags The tags attached to the saved search.
 * @property version The version number of the query language. The current version is 2 and is the default.
 * @property workspaceName The name of the workspace.
 */
public data class SavedSearchArgs(
    public val category: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val functionAlias: Output<String>? = null,
    public val functionParameters: Output<String>? = null,
    public val query: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val savedSearchId: Output<String>? = null,
    public val tags: Output<List<TagArgs>>? = null,
    public val version: Output<Double>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.SavedSearchArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.SavedSearchArgs =
        com.pulumi.azurenative.operationalinsights.SavedSearchArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .functionAlias(functionAlias?.applyValue({ args0 -> args0 }))
            .functionParameters(functionParameters?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .savedSearchId(savedSearchId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SavedSearchArgs].
 */
@PulumiTagMarker
public class SavedSearchArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var displayName: Output<String>? = null

    private var functionAlias: Output<String>? = null

    private var functionParameters: Output<String>? = null

    private var query: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var savedSearchId: Output<String>? = null

    private var tags: Output<List<TagArgs>>? = null

    private var version: Output<Double>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The category of the saved search. This helps the user to find a saved search faster.
     */
    @JvmName("ndakvavdlrunqgbq")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Saved search display name.
     */
    @JvmName("kiibtdxtkrwfdloo")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The function alias if query serves as a function.
     */
    @JvmName("sbwmtxcudgtbkmnx")
    public suspend fun functionAlias(`value`: Output<String>) {
        this.functionAlias = value
    }

    /**
     * @param value The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2 = default_value2'. For more examples and proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
     */
    @JvmName("vxqsiuvggauqvift")
    public suspend fun functionParameters(`value`: Output<String>) {
        this.functionParameters = value
    }

    /**
     * @param value The query expression for the saved search.
     */
    @JvmName("gkgawbpxbwtdgcrt")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pjksbuxeyjbjbphl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The id of the saved search.
     */
    @JvmName("sxefpuldxqcssoyh")
    public suspend fun savedSearchId(`value`: Output<String>) {
        this.savedSearchId = value
    }

    /**
     * @param value The tags attached to the saved search.
     */
    @JvmName("bctxpyxdkjbwkvvo")
    public suspend fun tags(`value`: Output<List<TagArgs>>) {
        this.tags = value
    }

    @JvmName("qaphvjviggmcuajo")
    public suspend fun tags(vararg values: Output<TagArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values The tags attached to the saved search.
     */
    @JvmName("orjaepxkqbmemsnd")
    public suspend fun tags(values: List<Output<TagArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value The version number of the query language. The current version is 2 and is the default.
     */
    @JvmName("wtfvyewcbapgauet")
    public suspend fun version(`value`: Output<Double>) {
        this.version = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("shqvfnprvqyaqmdv")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The category of the saved search. This helps the user to find a saved search faster.
     */
    @JvmName("gqbuyclwprcrifyt")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Saved search display name.
     */
    @JvmName("pdppkgskagxsardn")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The function alias if query serves as a function.
     */
    @JvmName("linjtejaispntrsd")
    public suspend fun functionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAlias = mapped
    }

    /**
     * @param value The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2 = default_value2'. For more examples and proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
     */
    @JvmName("dlhtpcyrmrmoofen")
    public suspend fun functionParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionParameters = mapped
    }

    /**
     * @param value The query expression for the saved search.
     */
    @JvmName("rplsgdhhxtpyhfkn")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kdxvpmqysivknvxv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The id of the saved search.
     */
    @JvmName("hgqhwfmgojlnwjnl")
    public suspend fun savedSearchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.savedSearchId = mapped
    }

    /**
     * @param value The tags attached to the saved search.
     */
    @JvmName("mnrdpfbinpdlvasx")
    public suspend fun tags(`value`: List<TagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument The tags attached to the saved search.
     */
    @JvmName("lrfrxkrciacxnern")
    public suspend fun tags(argument: List<suspend TagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument The tags attached to the saved search.
     */
    @JvmName("ehvdoxlxybcdiicv")
    public suspend fun tags(vararg argument: suspend TagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument The tags attached to the saved search.
     */
    @JvmName("nhjorbyoosjpjjhc")
    public suspend fun tags(argument: suspend TagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values The tags attached to the saved search.
     */
    @JvmName("fbiqwfsgyihecuhe")
    public suspend fun tags(vararg values: TagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The version number of the query language. The current version is 2 and is the default.
     */
    @JvmName("catjslebmpweaqon")
    public suspend fun version(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("jvckdiulqalpqiut")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SavedSearchArgs = SavedSearchArgs(
        category = category,
        displayName = displayName,
        functionAlias = functionAlias,
        functionParameters = functionParameters,
        query = query,
        resourceGroupName = resourceGroupName,
        savedSearchId = savedSearchId,
        tags = tags,
        version = version,
        workspaceName = workspaceName,
    )
}
