@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The provisioning state of the linked service.
 */
public enum class LinkedServiceEntityStatus(
    public val javaValue: com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus> {
    Succeeded(com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus.Succeeded),
    Deleting(com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus.Deleting),
    ProvisioningAccount(com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus.ProvisioningAccount),
    Updating(com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus.Updating),
    ;

    override fun toJava(): com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.enums.LinkedServiceEntityStatus):
            LinkedServiceEntityStatus =
            LinkedServiceEntityStatus.values().first { it.javaValue == javaType }
    }
}
