@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The network access type for accessing Log Analytics query.
 */
public enum class PublicNetworkAccessType(
    public val javaValue: com.pulumi.azurenative.operationalinsights.enums.PublicNetworkAccessType,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.enums.PublicNetworkAccessType> {
    /**
     * Enables connectivity to Log Analytics through public DNS.
     */
    Enabled(com.pulumi.azurenative.operationalinsights.enums.PublicNetworkAccessType.Enabled),

    /**
     * Disables public connectivity to Log Analytics through public DNS.
     */
    Disabled(com.pulumi.azurenative.operationalinsights.enums.PublicNetworkAccessType.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.operationalinsights.enums.PublicNetworkAccessType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.enums.PublicNetworkAccessType):
            PublicNetworkAccessType =
            PublicNetworkAccessType.values().first { it.javaValue == javaType }
    }
}
