@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetLinkedStorageAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataSourceType Linked storage accounts type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetLinkedStorageAccountPlainArgs(
    public val dataSourceType: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetLinkedStorageAccountPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationalinsights.inputs.GetLinkedStorageAccountPlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetLinkedStorageAccountPlainArgs.builder()
            .dataSourceType(dataSourceType.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinkedStorageAccountPlainArgs].
 */
@PulumiTagMarker
public class GetLinkedStorageAccountPlainArgsBuilder internal constructor() {
    private var dataSourceType: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Linked storage accounts type.
     */
    @JvmName("mhdkdmolgyxkpwwl")
    public suspend fun dataSourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataSourceType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mcpvwnqoojthbseo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("flcuiqhmpsqwogvg")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetLinkedStorageAccountPlainArgs = GetLinkedStorageAccountPlainArgs(
        dataSourceType = dataSourceType ?: throw PulumiNullFieldException("dataSourceType"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
