@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.SearchResultsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters of the search job that initiated this table.
 * @property description Search job Description.
 * @property endSearchTime The timestamp to end the search by (UTC)
 * @property limit Limit the search job to return up to specified number of rows.
 * @property query Search job query.
 * @property startSearchTime The timestamp to start the search from (UTC)
 */
public data class SearchResultsArgs(
    public val description: Output<String>? = null,
    public val endSearchTime: Output<String>? = null,
    public val limit: Output<Int>? = null,
    public val query: Output<String>? = null,
    public val startSearchTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.SearchResultsArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.SearchResultsArgs =
        com.pulumi.azurenative.operationalinsights.inputs.SearchResultsArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .endSearchTime(endSearchTime?.applyValue({ args0 -> args0 }))
            .limit(limit?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .startSearchTime(startSearchTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SearchResultsArgs].
 */
@PulumiTagMarker
public class SearchResultsArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var endSearchTime: Output<String>? = null

    private var limit: Output<Int>? = null

    private var query: Output<String>? = null

    private var startSearchTime: Output<String>? = null

    /**
     * @param value Search job Description.
     */
    @JvmName("ifvwccjwnqdauvou")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The timestamp to end the search by (UTC)
     */
    @JvmName("xiamvbcsnpdhsxwa")
    public suspend fun endSearchTime(`value`: Output<String>) {
        this.endSearchTime = value
    }

    /**
     * @param value Limit the search job to return up to specified number of rows.
     */
    @JvmName("qwkpjcesdmupjjwu")
    public suspend fun limit(`value`: Output<Int>) {
        this.limit = value
    }

    /**
     * @param value Search job query.
     */
    @JvmName("scqbmdevrjwswnxp")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The timestamp to start the search from (UTC)
     */
    @JvmName("ncmbmmrddsylrhmg")
    public suspend fun startSearchTime(`value`: Output<String>) {
        this.startSearchTime = value
    }

    /**
     * @param value Search job Description.
     */
    @JvmName("rmfbdpaxpqxuurdu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The timestamp to end the search by (UTC)
     */
    @JvmName("cbuypwvcrpkwccyk")
    public suspend fun endSearchTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endSearchTime = mapped
    }

    /**
     * @param value Limit the search job to return up to specified number of rows.
     */
    @JvmName("grfhvrfcososkpfb")
    public suspend fun limit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limit = mapped
    }

    /**
     * @param value Search job query.
     */
    @JvmName("ubjjytcdolaammjj")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The timestamp to start the search from (UTC)
     */
    @JvmName("nxdgrorccvcovoik")
    public suspend fun startSearchTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startSearchTime = mapped
    }

    internal fun build(): SearchResultsArgs = SearchResultsArgs(
        description = description,
        endSearchTime = endSearchTime,
        limit = limit,
        query = query,
        startSearchTime = startSearchTime,
    )
}
