@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.StorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a storage account connection.
 * @property id The Azure Resource Manager ID of the storage account resource.
 * @property key The storage account key.
 */
public data class StorageAccountArgs(
    public val id: Output<String>,
    public val key: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.StorageAccountArgs =
        com.pulumi.azurenative.operationalinsights.inputs.StorageAccountArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var key: Output<String>? = null

    /**
     * @param value The Azure Resource Manager ID of the storage account resource.
     */
    @JvmName("wnajbqwpaotepetu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The storage account key.
     */
    @JvmName("xnofvkaswvrgtbqs")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The Azure Resource Manager ID of the storage account resource.
     */
    @JvmName("iecbewhouoaqrhef")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The storage account key.
     */
    @JvmName("oeqybiabyiwcbtbi")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        key = key ?: throw PulumiNullFieldException("key"),
    )
}
