@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The list of Log Analytics workspaces associated with the cluster.
 * @property associateDate The time of workspace association.
 * @property resourceId The ResourceId id the assigned workspace.
 * @property workspaceId The id of the assigned workspace.
 * @property workspaceName The name id the assigned workspace.
 */
public data class AssociatedWorkspaceResponse(
    public val associateDate: String,
    public val resourceId: String,
    public val workspaceId: String,
    public val workspaceName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.AssociatedWorkspaceResponse):
            AssociatedWorkspaceResponse = AssociatedWorkspaceResponse(
            associateDate = javaType.associateDate(),
            resourceId = javaType.resourceId(),
            workspaceId = javaType.workspaceId(),
            workspaceName = javaType.workspaceName(),
        )
    }
}
