@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Table column.
 * @property dataTypeHint Column data type logical hint.
 * @property description Column description.
 * @property displayName Column display name.
 * @property isDefaultDisplay Is displayed by default.
 * @property isHidden Is column hidden.
 * @property name Column name.
 * @property type Column data type.
 */
public data class ColumnResponse(
    public val dataTypeHint: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val isDefaultDisplay: Boolean,
    public val isHidden: Boolean,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.ColumnResponse):
            ColumnResponse = ColumnResponse(
            dataTypeHint = javaType.dataTypeHint().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            isDefaultDisplay = javaType.isDefaultDisplay(),
            isHidden = javaType.isHidden(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
