@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The top level Linked service resource container.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the linked service.
 * @property resourceId The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require read access
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property writeAccessResourceId The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require write access
 */
public data class GetLinkedServiceResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val resourceId: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val writeAccessResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetLinkedServiceResult):
            GetLinkedServiceResult = GetLinkedServiceResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            writeAccessResourceId = javaType.writeAccessResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
