@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Workspace data table definition.
 * @property archiveRetentionInDays The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays)
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastPlanModifiedDate The timestamp that table plan was last modified (UTC).
 * @property name The name of the resource
 * @property plan Instruct the system how to handle and charge the logs ingested to this table.
 * @property provisioningState Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded.
 * @property restoredLogs Parameters of the restore operation that initiated this table.
 * @property resultStatistics Search job execution statistics.
 * @property retentionInDays The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
 * @property retentionInDaysAsDefault True - Value originates from workspace retention in days, False - Customer specific.
 * @property schema Table schema.
 * @property searchResults Parameters of the search job that initiated this table.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property totalRetentionInDays The table total retention in days, between 4 and 4383. Setting this property to -1 will default to table retention.
 * @property totalRetentionInDaysAsDefault True - Value originates from retention in days, False - Customer specific.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTableResult(
    public val archiveRetentionInDays: Int,
    public val id: String,
    public val lastPlanModifiedDate: String,
    public val name: String,
    public val plan: String? = null,
    public val provisioningState: String,
    public val restoredLogs: RestoredLogsResponse? = null,
    public val resultStatistics: ResultStatisticsResponse,
    public val retentionInDays: Int? = null,
    public val retentionInDaysAsDefault: Boolean,
    public val schema: SchemaResponse? = null,
    public val searchResults: SearchResultsResponse? = null,
    public val systemData: SystemDataResponse,
    public val totalRetentionInDays: Int? = null,
    public val totalRetentionInDaysAsDefault: Boolean,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetTableResult):
            GetTableResult = GetTableResult(
            archiveRetentionInDays = javaType.archiveRetentionInDays(),
            id = javaType.id(),
            lastPlanModifiedDate = javaType.lastPlanModifiedDate(),
            name = javaType.name(),
            plan = javaType.plan().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            restoredLogs = javaType.restoredLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.RestoredLogsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resultStatistics = javaType.resultStatistics().let({ args0 ->
                com.pulumi.azurenative.operationalinsights.kotlin.outputs.ResultStatisticsResponse.Companion.toKotlin(args0)
            }),
            retentionInDays = javaType.retentionInDays().map({ args0 -> args0 }).orElse(null),
            retentionInDaysAsDefault = javaType.retentionInDaysAsDefault(),
            schema = javaType.schema().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.SchemaResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            searchResults = javaType.searchResults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.SearchResultsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            totalRetentionInDays = javaType.totalRetentionInDays().map({ args0 -> args0 }).orElse(null),
            totalRetentionInDaysAsDefault = javaType.totalRetentionInDaysAsDefault(),
            type = javaType.type(),
        )
    }
}
