@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A machine reference with a hint of the machine's name and operating system.
 * @property displayNameHint Last known display name.
 * @property id Resource URI.
 * @property kind Specifies the sub-class of the reference.
 * Expected value is 'ref:machinewithhints'.
 * @property name Resource name.
 * @property osFamilyHint Last known operating system family.
 * @property type Resource type qualifier.
 */
public data class MachineReferenceWithHintsResponse(
    public val displayNameHint: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val osFamilyHint: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.MachineReferenceWithHintsResponse):
            MachineReferenceWithHintsResponse = MachineReferenceWithHintsResponse(
            displayNameHint = javaType.displayNameHint(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            osFamilyHint = javaType.osFamilyHint(),
            type = javaType.type(),
        )
    }
}
