@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a storage account connection.
 * @property id The Azure Resource Manager ID of the storage account resource.
 * @property key The storage account key.
 */
public data class StorageAccountResponse(
    public val id: String,
    public val key: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.StorageAccountResponse):
            StorageAccountResponse = StorageAccountResponse(
            id = javaType.id(),
            key = javaType.key(),
        )
    }
}
