@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Workspace features.
 * @property clusterResourceId Dedicated LA cluster resourceId that is linked to the workspaces.
 * @property disableLocalAuth Disable Non-AAD based Auth.
 * @property enableDataExport Flag that indicate if data should be exported.
 * @property enableLogAccessUsingOnlyResourcePermissions Flag that indicate which permission to use - resource or workspace or both.
 * @property immediatePurgeDataOn30Days Flag that describes if we want to remove the data after 30 days.
 */
public data class WorkspaceFeaturesResponse(
    public val clusterResourceId: String? = null,
    public val disableLocalAuth: Boolean? = null,
    public val enableDataExport: Boolean? = null,
    public val enableLogAccessUsingOnlyResourcePermissions: Boolean? = null,
    public val immediatePurgeDataOn30Days: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.WorkspaceFeaturesResponse):
            WorkspaceFeaturesResponse = WorkspaceFeaturesResponse(
            clusterResourceId = javaType.clusterResourceId().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            enableDataExport = javaType.enableDataExport().map({ args0 -> args0 }).orElse(null),
            enableLogAccessUsingOnlyResourcePermissions = javaType.enableLogAccessUsingOnlyResourcePermissions().map({ args0 ->
                args0
            }).orElse(null),
            immediatePurgeDataOn30Days = javaType.immediatePurgeDataOn30Days().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
