@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The SKU (tier) of a workspace.
 * @property capacityReservationLevel The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
 * @property lastSkuUpdate The last time when the sku was updated.
 * @property name The name of the SKU.
 */
public data class WorkspaceSkuResponse(
    public val capacityReservationLevel: Int? = null,
    public val lastSkuUpdate: String,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.WorkspaceSkuResponse):
            WorkspaceSkuResponse = WorkspaceSkuResponse(
            capacityReservationLevel = javaType.capacityReservationLevel().map({ args0 -> args0 }).orElse(null),
            lastSkuUpdate = javaType.lastSkuUpdate(),
            name = javaType.name(),
        )
    }
}
