@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.GetManagementConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementConfigurationName User Management Configuration Name.
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 */
public data class GetManagementConfigurationPlainArgs(
    public val managementConfigurationName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.GetManagementConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationsmanagement.inputs.GetManagementConfigurationPlainArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.GetManagementConfigurationPlainArgs.builder()
            .managementConfigurationName(managementConfigurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetManagementConfigurationPlainArgsBuilder internal constructor() {
    private var managementConfigurationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value User Management Configuration Name.
     */
    @JvmName("joulxibqnjfmgtvn")
    public suspend fun managementConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementConfigurationName = mapped
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("lshvckwekyfydbgd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagementConfigurationPlainArgs = GetManagementConfigurationPlainArgs(
        managementConfigurationName = managementConfigurationName ?: throw
            PulumiNullFieldException("managementConfigurationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
