@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.ManagementAssociationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ManagementAssociation properties supported by the OperationsManagement resource provider.
 * @property applicationId The applicationId of the appliance for this association.
 */
public data class ManagementAssociationPropertiesArgs(
    public val applicationId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.ManagementAssociationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationsmanagement.inputs.ManagementAssociationPropertiesArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.ManagementAssociationPropertiesArgs.builder()
            .applicationId(applicationId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementAssociationPropertiesArgs].
 */
@PulumiTagMarker
public class ManagementAssociationPropertiesArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    /**
     * @param value The applicationId of the appliance for this association.
     */
    @JvmName("qvsksbvhcwroqylt")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The applicationId of the appliance for this association.
     */
    @JvmName("iqsdsxhkqxilmeqg")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    internal fun build(): ManagementAssociationPropertiesArgs = ManagementAssociationPropertiesArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
    )
}
