@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The container for solution.
 * @property id Resource ID.
 * @property location Resource location
 * @property name Resource name.
 * @property plan Plan for solution object supported by the OperationsManagement resource provider.
 * @property properties Properties for solution object supported by the OperationsManagement resource provider.
 * @property tags Resource tags
 * @property type Resource type.
 */
public data class GetSolutionResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val plan: SolutionPlanResponse? = null,
    public val properties: SolutionPropertiesResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationsmanagement.outputs.GetSolutionResult):
            GetSolutionResult = GetSolutionResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationsmanagement.kotlin.outputs.SolutionPlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.operationsmanagement.kotlin.outputs.SolutionPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
