@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ManagementConfiguration properties supported by the OperationsManagement resource provider.
 * @property applicationId The applicationId of the appliance for this Management.
 * @property parameters Parameters to run the ARM template
 * @property parentResourceType The type of the parent resource.
 * @property provisioningState The provisioning state for the ManagementConfiguration.
 * @property template The Json object containing the ARM template to deploy
 */
public data class ManagementConfigurationPropertiesResponse(
    public val applicationId: String? = null,
    public val parameters: List<ArmTemplateParameterResponse>,
    public val parentResourceType: String,
    public val provisioningState: String,
    public val template: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationsmanagement.outputs.ManagementConfigurationPropertiesResponse):
            ManagementConfigurationPropertiesResponse = ManagementConfigurationPropertiesResponse(
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationsmanagement.kotlin.outputs.ArmTemplateParameterResponse.Companion.toKotlin(args0)
                })
            }),
            parentResourceType = javaType.parentResourceType(),
            provisioningState = javaType.provisioningState(),
            template = javaType.template(),
        )
    }
}
