@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.kotlin.outputs.ContactsPropertiesResponseAntennaConfiguration
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactsPropertiesResponseContactProfile
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactsPropertiesResponseAntennaConfiguration.Companion.toKotlin as contactsPropertiesResponseAntennaConfigurationToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactsPropertiesResponseContactProfile.Companion.toKotlin as contactsPropertiesResponseContactProfileToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Contact].
 */
@PulumiTagMarker
public class ContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactArgs = ContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactArgsBuilder.() -> Unit) {
        val builder = ContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Contact {
        val builtJavaResource = com.pulumi.azurenative.orbital.Contact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Contact(builtJavaResource)
    }
}

/**
 * Customer creates a contact resource for a spacecraft resource.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a contact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contact = new AzureNative.Orbital.Contact("contact", new()
 *     {
 *         ContactName = "contact1",
 *         ContactProfile = new AzureNative.Orbital.Inputs.ContactsPropertiesContactProfileArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/contactProfiles/CONTOSO-CP",
 *         },
 *         GroundStationName = "EASTUS2_0",
 *         ReservationEndTime = "2023-02-22T11:10:45Z",
 *         ReservationStartTime = "2023-02-22T10:58:30Z",
 *         ResourceGroupName = "contoso-Rgp",
 *         SpacecraftName = "CONTOSO_SAT",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewContact(ctx, "contact", &orbital.ContactArgs{
 * 			ContactName: pulumi.String("contact1"),
 * 			ContactProfile: &orbital.ContactsPropertiesContactProfileArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/contactProfiles/CONTOSO-CP"),
 * 			},
 * 			GroundStationName:    pulumi.String("EASTUS2_0"),
 * 			ReservationEndTime:   pulumi.String("2023-02-22T11:10:45Z"),
 * 			ReservationStartTime: pulumi.String("2023-02-22T10:58:30Z"),
 * 			ResourceGroupName:    pulumi.String("contoso-Rgp"),
 * 			SpacecraftName:       pulumi.String("CONTOSO_SAT"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.Contact;
 * import com.pulumi.azurenative.orbital.ContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contact = new Contact("contact", ContactArgs.builder()
 *             .contactName("contact1")
 *             .contactProfile(Map.of("id", "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/contactProfiles/CONTOSO-CP"))
 *             .groundStationName("EASTUS2_0")
 *             .reservationEndTime("2023-02-22T11:10:45Z")
 *             .reservationStartTime("2023-02-22T10:58:30Z")
 *             .resourceGroupName("contoso-Rgp")
 *             .spacecraftName("CONTOSO_SAT")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:Contact contact1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/spacecrafts/{spacecraftName}/contacts/{contactName}
 * ```
 */
public class Contact internal constructor(
    override val javaResource: com.pulumi.azurenative.orbital.Contact,
) : KotlinCustomResource(javaResource, ContactMapper) {
    /**
     * The configuration associated with the allocated antenna.
     */
    public val antennaConfiguration: Output<ContactsPropertiesResponseAntennaConfiguration>
        get() = javaResource.antennaConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                contactsPropertiesResponseAntennaConfigurationToKotlin(args0)
            })
        })

    /**
     * The reference to the contact profile resource.
     */
    public val contactProfile: Output<ContactsPropertiesResponseContactProfile>
        get() = javaResource.contactProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                contactsPropertiesResponseContactProfileToKotlin(args0)
            })
        })

    /**
     * Azimuth of the antenna at the end of the contact in decimal degrees.
     */
    public val endAzimuthDegrees: Output<Double>
        get() = javaResource.endAzimuthDegrees().applyValue({ args0 -> args0 })

    /**
     * Spacecraft elevation above the horizon at contact end.
     */
    public val endElevationDegrees: Output<Double>
        get() = javaResource.endElevationDegrees().applyValue({ args0 -> args0 })

    /**
     * Any error message while scheduling a contact.
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * Azure Ground Station name.
     */
    public val groundStationName: Output<String>
        get() = javaResource.groundStationName().applyValue({ args0 -> args0 })

    /**
     * Maximum elevation of the antenna during the contact in decimal degrees.
     */
    public val maximumElevationDegrees: Output<Double>
        get() = javaResource.maximumElevationDegrees().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Reservation end time of a contact (ISO 8601 UTC standard).
     */
    public val reservationEndTime: Output<String>
        get() = javaResource.reservationEndTime().applyValue({ args0 -> args0 })

    /**
     * Reservation start time of a contact (ISO 8601 UTC standard).
     */
    public val reservationStartTime: Output<String>
        get() = javaResource.reservationStartTime().applyValue({ args0 -> args0 })

    /**
     * Receive end time of a contact (ISO 8601 UTC standard).
     */
    public val rxEndTime: Output<String>
        get() = javaResource.rxEndTime().applyValue({ args0 -> args0 })

    /**
     * Receive start time of a contact (ISO 8601 UTC standard).
     */
    public val rxStartTime: Output<String>
        get() = javaResource.rxStartTime().applyValue({ args0 -> args0 })

    /**
     * Azimuth of the antenna at the start of the contact in decimal degrees.
     */
    public val startAzimuthDegrees: Output<Double>
        get() = javaResource.startAzimuthDegrees().applyValue({ args0 -> args0 })

    /**
     * Spacecraft elevation above the horizon at contact start.
     */
    public val startElevationDegrees: Output<Double>
        get() = javaResource.startElevationDegrees().applyValue({ args0 -> args0 })

    /**
     * Status of a contact.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Transmit end time of a contact (ISO 8601 UTC standard).
     */
    public val txEndTime: Output<String>
        get() = javaResource.txEndTime().applyValue({ args0 -> args0 })

    /**
     * Transmit start time of a contact (ISO 8601 UTC standard).
     */
    public val txStartTime: Output<String>
        get() = javaResource.txStartTime().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContactMapper : ResourceMapper<Contact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.orbital.Contact::class == javaResource::class

    override fun map(javaResource: Resource): Contact = Contact(
        javaResource as
            com.pulumi.azurenative.orbital.Contact,
    )
}

/**
 * @see [Contact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Contact].
 */
public suspend fun contact(name: String, block: suspend ContactResourceBuilder.() -> Unit):
    Contact {
    val builder = ContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Contact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contact(name: String): Contact {
    val builder = ContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
