@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileLinkResponse
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileThirdPartyConfigurationResponse
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfilesPropertiesResponseNetworkConfiguration
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileLinkResponse.Companion.toKotlin as contactProfileLinkResponseToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileThirdPartyConfigurationResponse.Companion.toKotlin as contactProfileThirdPartyConfigurationResponseToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfilesPropertiesResponseNetworkConfiguration.Companion.toKotlin as contactProfilesPropertiesResponseNetworkConfigurationToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContactProfile].
 */
@PulumiTagMarker
public class ContactProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactProfileArgs = ContactProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactProfileArgsBuilder.() -> Unit) {
        val builder = ContactProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContactProfile {
        val builtJavaResource = com.pulumi.azurenative.orbital.ContactProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContactProfile(builtJavaResource)
    }
}

/**
 * Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a contact profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contactProfile = new AzureNative.Orbital.ContactProfile("contactProfile", new()
 *     {
 *         AutoTrackingConfiguration = AzureNative.Orbital.AutoTrackingConfiguration.Disabled,
 *         ContactProfileName = "CONTOSO-CP",
 *         EventHubUri = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub",
 *         Links = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 2,
 *                         CenterFrequencyMHz = 2250,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Uplink",
 *                             IpAddress = "10.1.0.4",
 *                             Port = "50000",
 *                             Protocol = "TCP",
 *                         },
 *                         Name = "contoso-uplink-channel",
 *                     },
 *                 },
 *                 Direction = "Uplink",
 *                 EirpdBW = 45,
 *                 GainOverTemperature = 0,
 *                 Name = "contoso-uplink",
 *                 Polarization = "LHCP",
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 15,
 *                         CenterFrequencyMHz = 8160,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Downlink",
 *                             IpAddress = "10.1.0.5",
 *                             Port = "50001",
 *                             Protocol = "UDP",
 *                         },
 *                         Name = "contoso-downlink-channel",
 *                     },
 *                 },
 *                 Direction = "Downlink",
 *                 EirpdBW = 0,
 *                 GainOverTemperature = 25,
 *                 Name = "contoso-downlink",
 *                 Polarization = "RHCP",
 *             },
 *         },
 *         Location = "eastus2",
 *         MinimumElevationDegrees = 5,
 *         MinimumViableContactDuration = "PT1M",
 *         NetworkConfiguration = new AzureNative.Orbital.Inputs.ContactProfilesPropertiesNetworkConfigurationArgs
 *         {
 *             SubnetId = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet",
 *         },
 *         ResourceGroupName = "contoso-Rgp",
 *         ThirdPartyConfigurations = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Ksat_MissionConfiguration",
 *                 ProviderName = "KSAT",
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Viasat_Configuration",
 *                 ProviderName = "VIASAT",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewContactProfile(ctx, "contactProfile", &orbital.ContactProfileArgs{
 * 			AutoTrackingConfiguration: orbital.AutoTrackingConfigurationDisabled,
 * 			ContactProfileName:        pulumi.String("CONTOSO-CP"),
 * 			EventHubUri:               pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub"),
 * 			Links: []orbital.ContactProfileLinkArgs{
 * 				{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						{
 * 							BandwidthMHz:       pulumi.Float64(2),
 * 							CenterFrequencyMHz: pulumi.Float64(2250),
 * 							EndPoint: {
 * 								EndPointName: pulumi.String("ContosoTest_Uplink"),
 * 								IpAddress:    pulumi.String("10.1.0.4"),
 * 								Port:         pulumi.String("50000"),
 * 								Protocol:     pulumi.String("TCP"),
 * 							},
 * 							Name: pulumi.String("contoso-uplink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String("Uplink"),
 * 					EirpdBW:             pulumi.Float64(45),
 * 					GainOverTemperature: pulumi.Float64(0),
 * 					Name:                pulumi.String("contoso-uplink"),
 * 					Polarization:        pulumi.String("LHCP"),
 * 				},
 * 				{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						{
 * 							BandwidthMHz:       pulumi.Float64(15),
 * 							CenterFrequencyMHz: pulumi.Float64(8160),
 * 							EndPoint: {
 * 								EndPointName: pulumi.String("ContosoTest_Downlink"),
 * 								IpAddress:    pulumi.String("10.1.0.5"),
 * 								Port:         pulumi.String("50001"),
 * 								Protocol:     pulumi.String("UDP"),
 * 							},
 * 							Name: pulumi.String("contoso-downlink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String("Downlink"),
 * 					EirpdBW:             pulumi.Float64(0),
 * 					GainOverTemperature: pulumi.Float64(25),
 * 					Name:                pulumi.String("contoso-downlink"),
 * 					Polarization:        pulumi.String("RHCP"),
 * 				},
 * 			},
 * 			Location:                     pulumi.String("eastus2"),
 * 			MinimumElevationDegrees:      pulumi.Float64(5),
 * 			MinimumViableContactDuration: pulumi.String("PT1M"),
 * 			NetworkConfiguration: &orbital.ContactProfilesPropertiesNetworkConfigurationArgs{
 * 				SubnetId: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-Rgp"),
 * 			ThirdPartyConfigurations: []orbital.ContactProfileThirdPartyConfigurationArgs{
 * 				{
 * 					MissionConfiguration: pulumi.String("Ksat_MissionConfiguration"),
 * 					ProviderName:         pulumi.String("KSAT"),
 * 				},
 * 				{
 * 					MissionConfiguration: pulumi.String("Viasat_Configuration"),
 * 					ProviderName:         pulumi.String("VIASAT"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.ContactProfile;
 * import com.pulumi.azurenative.orbital.ContactProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contactProfile = new ContactProfile("contactProfile", ContactProfileArgs.builder()
 *             .autoTrackingConfiguration("disabled")
 *             .contactProfileName("CONTOSO-CP")
 *             .eventHubUri("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub")
 *             .links(
 *                 Map.ofEntries(
 *                     Map.entry("channels", Map.ofEntries(
 *                         Map.entry("bandwidthMHz", 2),
 *                         Map.entry("centerFrequencyMHz", 2250),
 *                         Map.entry("endPoint", Map.ofEntries(
 *                             Map.entry("endPointName", "ContosoTest_Uplink"),
 *                             Map.entry("ipAddress", "10.1.0.4"),
 *                             Map.entry("port", "50000"),
 *                             Map.entry("protocol", "TCP")
 *                         )),
 *                         Map.entry("name", "contoso-uplink-channel")
 *                     )),
 *                     Map.entry("direction", "Uplink"),
 *                     Map.entry("eirpdBW", 45),
 *                     Map.entry("gainOverTemperature", 0),
 *                     Map.entry("name", "contoso-uplink"),
 *                     Map.entry("polarization", "LHCP")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("channels", Map.ofEntries(
 *                         Map.entry("bandwidthMHz", 15),
 *                         Map.entry("centerFrequencyMHz", 8160),
 *                         Map.entry("endPoint", Map.ofEntries(
 *                             Map.entry("endPointName", "ContosoTest_Downlink"),
 *                             Map.entry("ipAddress", "10.1.0.5"),
 *                             Map.entry("port", "50001"),
 *                             Map.entry("protocol", "UDP")
 *                         )),
 *                         Map.entry("name", "contoso-downlink-channel")
 *                     )),
 *                     Map.entry("direction", "Downlink"),
 *                     Map.entry("eirpdBW", 0),
 *                     Map.entry("gainOverTemperature", 25),
 *                     Map.entry("name", "contoso-downlink"),
 *                     Map.entry("polarization", "RHCP")
 *                 ))
 *             .location("eastus2")
 *             .minimumElevationDegrees(5)
 *             .minimumViableContactDuration("PT1M")
 *             .networkConfiguration(Map.of("subnetId", "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet"))
 *             .resourceGroupName("contoso-Rgp")
 *             .thirdPartyConfigurations(
 *                 Map.ofEntries(
 *                     Map.entry("missionConfiguration", "Ksat_MissionConfiguration"),
 *                     Map.entry("providerName", "KSAT")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("missionConfiguration", "Viasat_Configuration"),
 *                     Map.entry("providerName", "VIASAT")
 *                 ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:ContactProfile CONTOSO-CP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}
 * ```
 */
public class ContactProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.orbital.ContactProfile,
) : KotlinCustomResource(javaResource, ContactProfileMapper) {
    /**
     * Auto-tracking configuration.
     */
    public val autoTrackingConfiguration: Output<String>?
        get() = javaResource.autoTrackingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
     */
    public val eventHubUri: Output<String>?
        get() = javaResource.eventHubUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    public val links: Output<List<ContactProfileLinkResponse>>
        get() = javaResource.links().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    contactProfileLinkResponseToKotlin(args0)
                })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    public val minimumElevationDegrees: Output<Double>?
        get() = javaResource.minimumElevationDegrees().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    public val minimumViableContactDuration: Output<String>?
        get() = javaResource.minimumViableContactDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network configuration of customer virtual network.
     */
    public val networkConfiguration: Output<ContactProfilesPropertiesResponseNetworkConfiguration>
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                contactProfilesPropertiesResponseNetworkConfigurationToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    public val thirdPartyConfigurations: Output<List<ContactProfileThirdPartyConfigurationResponse>>?
        get() = javaResource.thirdPartyConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        contactProfileThirdPartyConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContactProfileMapper : ResourceMapper<ContactProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.orbital.ContactProfile::class == javaResource::class

    override fun map(javaResource: Resource): ContactProfile = ContactProfile(
        javaResource as
            com.pulumi.azurenative.orbital.ContactProfile,
    )
}

/**
 * @see [ContactProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContactProfile].
 */
public suspend fun contactProfile(
    name: String,
    block: suspend ContactProfileResourceBuilder.() -> Unit,
): ContactProfile {
    val builder = ContactProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContactProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contactProfile(name: String): ContactProfile {
    val builder = ContactProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
