@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.ContactProfileArgs.builder
import com.pulumi.azurenative.orbital.kotlin.enums.AutoTrackingConfiguration
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileLinkArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileLinkArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileThirdPartyConfigurationArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileThirdPartyConfigurationArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfilesPropertiesNetworkConfigurationArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfilesPropertiesNetworkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a contact profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contactProfile = new AzureNative.Orbital.ContactProfile("contactProfile", new()
 *     {
 *         AutoTrackingConfiguration = AzureNative.Orbital.AutoTrackingConfiguration.Disabled,
 *         ContactProfileName = "CONTOSO-CP",
 *         EventHubUri = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub",
 *         Links = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 2,
 *                         CenterFrequencyMHz = 2250,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Uplink",
 *                             IpAddress = "10.1.0.4",
 *                             Port = "50000",
 *                             Protocol = "TCP",
 *                         },
 *                         Name = "contoso-uplink-channel",
 *                     },
 *                 },
 *                 Direction = "Uplink",
 *                 EirpdBW = 45,
 *                 GainOverTemperature = 0,
 *                 Name = "contoso-uplink",
 *                 Polarization = "LHCP",
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 15,
 *                         CenterFrequencyMHz = 8160,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Downlink",
 *                             IpAddress = "10.1.0.5",
 *                             Port = "50001",
 *                             Protocol = "UDP",
 *                         },
 *                         Name = "contoso-downlink-channel",
 *                     },
 *                 },
 *                 Direction = "Downlink",
 *                 EirpdBW = 0,
 *                 GainOverTemperature = 25,
 *                 Name = "contoso-downlink",
 *                 Polarization = "RHCP",
 *             },
 *         },
 *         Location = "eastus2",
 *         MinimumElevationDegrees = 5,
 *         MinimumViableContactDuration = "PT1M",
 *         NetworkConfiguration = new AzureNative.Orbital.Inputs.ContactProfilesPropertiesNetworkConfigurationArgs
 *         {
 *             SubnetId = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet",
 *         },
 *         ResourceGroupName = "contoso-Rgp",
 *         ThirdPartyConfigurations = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Ksat_MissionConfiguration",
 *                 ProviderName = "KSAT",
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Viasat_Configuration",
 *                 ProviderName = "VIASAT",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewContactProfile(ctx, "contactProfile", &orbital.ContactProfileArgs{
 * 			AutoTrackingConfiguration: orbital.AutoTrackingConfigurationDisabled,
 * 			ContactProfileName:        pulumi.String("CONTOSO-CP"),
 * 			EventHubUri:               pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub"),
 * 			Links: []orbital.ContactProfileLinkArgs{
 * 				{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						{
 * 							BandwidthMHz:       pulumi.Float64(2),
 * 							CenterFrequencyMHz: pulumi.Float64(2250),
 * 							EndPoint: {
 * 								EndPointName: pulumi.String("ContosoTest_Uplink"),
 * 								IpAddress:    pulumi.String("10.1.0.4"),
 * 								Port:         pulumi.String("50000"),
 * 								Protocol:     pulumi.String("TCP"),
 * 							},
 * 							Name: pulumi.String("contoso-uplink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String("Uplink"),
 * 					EirpdBW:             pulumi.Float64(45),
 * 					GainOverTemperature: pulumi.Float64(0),
 * 					Name:                pulumi.String("contoso-uplink"),
 * 					Polarization:        pulumi.String("LHCP"),
 * 				},
 * 				{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						{
 * 							BandwidthMHz:       pulumi.Float64(15),
 * 							CenterFrequencyMHz: pulumi.Float64(8160),
 * 							EndPoint: {
 * 								EndPointName: pulumi.String("ContosoTest_Downlink"),
 * 								IpAddress:    pulumi.String("10.1.0.5"),
 * 								Port:         pulumi.String("50001"),
 * 								Protocol:     pulumi.String("UDP"),
 * 							},
 * 							Name: pulumi.String("contoso-downlink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String("Downlink"),
 * 					EirpdBW:             pulumi.Float64(0),
 * 					GainOverTemperature: pulumi.Float64(25),
 * 					Name:                pulumi.String("contoso-downlink"),
 * 					Polarization:        pulumi.String("RHCP"),
 * 				},
 * 			},
 * 			Location:                     pulumi.String("eastus2"),
 * 			MinimumElevationDegrees:      pulumi.Float64(5),
 * 			MinimumViableContactDuration: pulumi.String("PT1M"),
 * 			NetworkConfiguration: &orbital.ContactProfilesPropertiesNetworkConfigurationArgs{
 * 				SubnetId: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-Rgp"),
 * 			ThirdPartyConfigurations: []orbital.ContactProfileThirdPartyConfigurationArgs{
 * 				{
 * 					MissionConfiguration: pulumi.String("Ksat_MissionConfiguration"),
 * 					ProviderName:         pulumi.String("KSAT"),
 * 				},
 * 				{
 * 					MissionConfiguration: pulumi.String("Viasat_Configuration"),
 * 					ProviderName:         pulumi.String("VIASAT"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.ContactProfile;
 * import com.pulumi.azurenative.orbital.ContactProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contactProfile = new ContactProfile("contactProfile", ContactProfileArgs.builder()
 *             .autoTrackingConfiguration("disabled")
 *             .contactProfileName("CONTOSO-CP")
 *             .eventHubUri("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub")
 *             .links(
 *                 Map.ofEntries(
 *                     Map.entry("channels", Map.ofEntries(
 *                         Map.entry("bandwidthMHz", 2),
 *                         Map.entry("centerFrequencyMHz", 2250),
 *                         Map.entry("endPoint", Map.ofEntries(
 *                             Map.entry("endPointName", "ContosoTest_Uplink"),
 *                             Map.entry("ipAddress", "10.1.0.4"),
 *                             Map.entry("port", "50000"),
 *                             Map.entry("protocol", "TCP")
 *                         )),
 *                         Map.entry("name", "contoso-uplink-channel")
 *                     )),
 *                     Map.entry("direction", "Uplink"),
 *                     Map.entry("eirpdBW", 45),
 *                     Map.entry("gainOverTemperature", 0),
 *                     Map.entry("name", "contoso-uplink"),
 *                     Map.entry("polarization", "LHCP")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("channels", Map.ofEntries(
 *                         Map.entry("bandwidthMHz", 15),
 *                         Map.entry("centerFrequencyMHz", 8160),
 *                         Map.entry("endPoint", Map.ofEntries(
 *                             Map.entry("endPointName", "ContosoTest_Downlink"),
 *                             Map.entry("ipAddress", "10.1.0.5"),
 *                             Map.entry("port", "50001"),
 *                             Map.entry("protocol", "UDP")
 *                         )),
 *                         Map.entry("name", "contoso-downlink-channel")
 *                     )),
 *                     Map.entry("direction", "Downlink"),
 *                     Map.entry("eirpdBW", 0),
 *                     Map.entry("gainOverTemperature", 25),
 *                     Map.entry("name", "contoso-downlink"),
 *                     Map.entry("polarization", "RHCP")
 *                 ))
 *             .location("eastus2")
 *             .minimumElevationDegrees(5)
 *             .minimumViableContactDuration("PT1M")
 *             .networkConfiguration(Map.of("subnetId", "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet"))
 *             .resourceGroupName("contoso-Rgp")
 *             .thirdPartyConfigurations(
 *                 Map.ofEntries(
 *                     Map.entry("missionConfiguration", "Ksat_MissionConfiguration"),
 *                     Map.entry("providerName", "KSAT")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("missionConfiguration", "Viasat_Configuration"),
 *                     Map.entry("providerName", "VIASAT")
 *                 ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:ContactProfile CONTOSO-CP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}
 * ```
 * @property autoTrackingConfiguration Auto-tracking configuration.
 * @property contactProfileName Contact Profile name.
 * @property eventHubUri ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
 * @property links Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
 * @property location The geo-location where the resource lives
 * @property minimumElevationDegrees Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
 * @property minimumViableContactDuration Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
 * @property networkConfiguration Network configuration of customer virtual network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property thirdPartyConfigurations Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
 */
public data class ContactProfileArgs(
    public val autoTrackingConfiguration: Output<AutoTrackingConfiguration>? = null,
    public val contactProfileName: Output<String>? = null,
    public val eventHubUri: Output<String>? = null,
    public val links: Output<List<ContactProfileLinkArgs>>? = null,
    public val location: Output<String>? = null,
    public val minimumElevationDegrees: Output<Double>? = null,
    public val minimumViableContactDuration: Output<String>? = null,
    public val networkConfiguration: Output<ContactProfilesPropertiesNetworkConfigurationArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val thirdPartyConfigurations: Output<List<ContactProfileThirdPartyConfigurationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.ContactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.ContactProfileArgs =
        com.pulumi.azurenative.orbital.ContactProfileArgs.builder()
            .autoTrackingConfiguration(
                autoTrackingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .contactProfileName(contactProfileName?.applyValue({ args0 -> args0 }))
            .eventHubUri(eventHubUri?.applyValue({ args0 -> args0 }))
            .links(links?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumElevationDegrees(minimumElevationDegrees?.applyValue({ args0 -> args0 }))
            .minimumViableContactDuration(minimumViableContactDuration?.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .thirdPartyConfigurations(
                thirdPartyConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContactProfileArgs].
 */
@PulumiTagMarker
public class ContactProfileArgsBuilder internal constructor() {
    private var autoTrackingConfiguration: Output<AutoTrackingConfiguration>? = null

    private var contactProfileName: Output<String>? = null

    private var eventHubUri: Output<String>? = null

    private var links: Output<List<ContactProfileLinkArgs>>? = null

    private var location: Output<String>? = null

    private var minimumElevationDegrees: Output<Double>? = null

    private var minimumViableContactDuration: Output<String>? = null

    private var networkConfiguration: Output<ContactProfilesPropertiesNetworkConfigurationArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var thirdPartyConfigurations: Output<List<ContactProfileThirdPartyConfigurationArgs>>? =
        null

    /**
     * @param value Auto-tracking configuration.
     */
    @JvmName("sitsosebfdirhtds")
    public suspend fun autoTrackingConfiguration(`value`: Output<AutoTrackingConfiguration>) {
        this.autoTrackingConfiguration = value
    }

    /**
     * @param value Contact Profile name.
     */
    @JvmName("pamimamkvgprqnrg")
    public suspend fun contactProfileName(`value`: Output<String>) {
        this.contactProfileName = value
    }

    /**
     * @param value ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
     */
    @JvmName("mmcrrexpjodwxlbh")
    public suspend fun eventHubUri(`value`: Output<String>) {
        this.eventHubUri = value
    }

    /**
     * @param value Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("myicgesxqsqtvdgy")
    public suspend fun links(`value`: Output<List<ContactProfileLinkArgs>>) {
        this.links = value
    }

    @JvmName("mbtgxtjxfetwhafp")
    public suspend fun links(vararg values: Output<ContactProfileLinkArgs>) {
        this.links = Output.all(values.asList())
    }

    /**
     * @param values Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("ycvhpljdtfomqwoy")
    public suspend fun links(values: List<Output<ContactProfileLinkArgs>>) {
        this.links = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tpstcfuhyewdumls")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("sabpoiumakpcixqw")
    public suspend fun minimumElevationDegrees(`value`: Output<Double>) {
        this.minimumElevationDegrees = value
    }

    /**
     * @param value Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("rkuyurjytelnipmw")
    public suspend fun minimumViableContactDuration(`value`: Output<String>) {
        this.minimumViableContactDuration = value
    }

    /**
     * @param value Network configuration of customer virtual network.
     */
    @JvmName("nnbxlwjvnyrrwbkd")
    public suspend
    fun networkConfiguration(`value`: Output<ContactProfilesPropertiesNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xxmnlsssisialfck")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tnhmnifcrisskbbf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("nsumenboulslxolf")
    public suspend
    fun thirdPartyConfigurations(`value`: Output<List<ContactProfileThirdPartyConfigurationArgs>>) {
        this.thirdPartyConfigurations = value
    }

    @JvmName("iigtokvhrgggeyax")
    public suspend fun thirdPartyConfigurations(
        vararg
        values: Output<ContactProfileThirdPartyConfigurationArgs>,
    ) {
        this.thirdPartyConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("yefmtnfgmqaiiydl")
    public suspend
    fun thirdPartyConfigurations(values: List<Output<ContactProfileThirdPartyConfigurationArgs>>) {
        this.thirdPartyConfigurations = Output.all(values)
    }

    /**
     * @param value Auto-tracking configuration.
     */
    @JvmName("dtbxdrdxepqdpxxt")
    public suspend fun autoTrackingConfiguration(`value`: AutoTrackingConfiguration?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoTrackingConfiguration = mapped
    }

    /**
     * @param value Contact Profile name.
     */
    @JvmName("ihyjcwyllsxmtabp")
    public suspend fun contactProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactProfileName = mapped
    }

    /**
     * @param value ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
     */
    @JvmName("utgpjdpnqsmomobk")
    public suspend fun eventHubUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubUri = mapped
    }

    /**
     * @param value Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("wsbrjreccglgoiws")
    public suspend fun links(`value`: List<ContactProfileLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param argument Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("lqkwtvarrsxltrlf")
    public suspend fun links(argument: List<suspend ContactProfileLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactProfileLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("nurokdkbpsgeepcu")
    public suspend fun links(vararg argument: suspend ContactProfileLinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactProfileLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("tnnyhitvvlopaiky")
    public suspend fun links(argument: suspend ContactProfileLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContactProfileLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param values Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("cttxulodjrdojlnl")
    public suspend fun links(vararg values: ContactProfileLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rxpnpvnhxiajeqbn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("bejpmmqjjpnmijtx")
    public suspend fun minimumElevationDegrees(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumElevationDegrees = mapped
    }

    /**
     * @param value Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("sivpurhpkguchlcq")
    public suspend fun minimumViableContactDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumViableContactDuration = mapped
    }

    /**
     * @param value Network configuration of customer virtual network.
     */
    @JvmName("yusyrsjsopaqqutp")
    public suspend
    fun networkConfiguration(`value`: ContactProfilesPropertiesNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Network configuration of customer virtual network.
     */
    @JvmName("mkamwomkmdvgtjsh")
    public suspend
    fun networkConfiguration(argument: suspend ContactProfilesPropertiesNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContactProfilesPropertiesNetworkConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ngtrpchqynhmjftd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("chbsoisphismmjbt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xmtcbshidxorswfe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("pavhpfflkxvsqdia")
    public suspend
    fun thirdPartyConfigurations(`value`: List<ContactProfileThirdPartyConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param argument Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("iotkrttogcwsjivc")
    public suspend
    fun thirdPartyConfigurations(argument: List<suspend ContactProfileThirdPartyConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactProfileThirdPartyConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param argument Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("uldesberrapjxaju")
    public suspend fun thirdPartyConfigurations(
        vararg
        argument: suspend ContactProfileThirdPartyConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContactProfileThirdPartyConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param argument Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("sjrybqungsqjjutt")
    public suspend
    fun thirdPartyConfigurations(argument: suspend ContactProfileThirdPartyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContactProfileThirdPartyConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param values Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("lbcjctyefktpjjbm")
    public suspend fun thirdPartyConfigurations(
        vararg
        values: ContactProfileThirdPartyConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thirdPartyConfigurations = mapped
    }

    internal fun build(): ContactProfileArgs = ContactProfileArgs(
        autoTrackingConfiguration = autoTrackingConfiguration,
        contactProfileName = contactProfileName,
        eventHubUri = eventHubUri,
        links = links,
        location = location,
        minimumElevationDegrees = minimumElevationDegrees,
        minimumViableContactDuration = minimumViableContactDuration,
        networkConfiguration = networkConfiguration,
        resourceGroupName = resourceGroupName,
        tags = tags,
        thirdPartyConfigurations = thirdPartyConfigurations,
    )
}
