@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ContactProfileLinkArgs.builder
import com.pulumi.azurenative.orbital.kotlin.enums.Direction
import com.pulumi.azurenative.orbital.kotlin.enums.Polarization
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contact Profile Link.
 * @property channels Contact Profile Link Channel.
 * @property direction Direction (Uplink or Downlink).
 * @property eirpdBW Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet.
 * @property gainOverTemperature Gain to noise temperature in db/K. It is the required G/T by the customer. Not used yet.
 * @property name Link name.
 * @property polarization Polarization. e.g. (RHCP, LHCP).
 */
public data class ContactProfileLinkArgs(
    public val channels: Output<List<ContactProfileLinkChannelArgs>>,
    public val direction: Output<Either<String, Direction>>,
    public val eirpdBW: Output<Double>? = null,
    public val gainOverTemperature: Output<Double>? = null,
    public val name: Output<String>,
    public val polarization: Output<Either<String, Polarization>>,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ContactProfileLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.ContactProfileLinkArgs =
        com.pulumi.azurenative.orbital.inputs.ContactProfileLinkArgs.builder()
            .channels(
                channels.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eirpdBW(eirpdBW?.applyValue({ args0 -> args0 }))
            .gainOverTemperature(gainOverTemperature?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .polarization(
                polarization.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContactProfileLinkArgs].
 */
@PulumiTagMarker
public class ContactProfileLinkArgsBuilder internal constructor() {
    private var channels: Output<List<ContactProfileLinkChannelArgs>>? = null

    private var direction: Output<Either<String, Direction>>? = null

    private var eirpdBW: Output<Double>? = null

    private var gainOverTemperature: Output<Double>? = null

    private var name: Output<String>? = null

    private var polarization: Output<Either<String, Polarization>>? = null

    /**
     * @param value Contact Profile Link Channel.
     */
    @JvmName("brhmdofguwvmxqgb")
    public suspend fun channels(`value`: Output<List<ContactProfileLinkChannelArgs>>) {
        this.channels = value
    }

    @JvmName("dtbmbiqhhlnlknam")
    public suspend fun channels(vararg values: Output<ContactProfileLinkChannelArgs>) {
        this.channels = Output.all(values.asList())
    }

    /**
     * @param values Contact Profile Link Channel.
     */
    @JvmName("mrghksqjfnlmghbc")
    public suspend fun channels(values: List<Output<ContactProfileLinkChannelArgs>>) {
        this.channels = Output.all(values)
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("qqfeiqqebkhcfawl")
    public suspend fun direction(`value`: Output<Either<String, Direction>>) {
        this.direction = value
    }

    /**
     * @param value Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet.
     */
    @JvmName("kjrmbtqnrybotamv")
    public suspend fun eirpdBW(`value`: Output<Double>) {
        this.eirpdBW = value
    }

    /**
     * @param value Gain to noise temperature in db/K. It is the required G/T by the customer. Not used yet.
     */
    @JvmName("wevqmgrabdixcgfu")
    public suspend fun gainOverTemperature(`value`: Output<Double>) {
        this.gainOverTemperature = value
    }

    /**
     * @param value Link name.
     */
    @JvmName("agedotafqqnfdvge")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("kermgmbfcxcjfmeo")
    public suspend fun polarization(`value`: Output<Either<String, Polarization>>) {
        this.polarization = value
    }

    /**
     * @param value Contact Profile Link Channel.
     */
    @JvmName("xxmahbdtxlomtjsi")
    public suspend fun channels(`value`: List<ContactProfileLinkChannelArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channels = mapped
    }

    /**
     * @param argument Contact Profile Link Channel.
     */
    @JvmName("adqkmjitjqlrupvy")
    public suspend
    fun channels(argument: List<suspend ContactProfileLinkChannelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactProfileLinkChannelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.channels = mapped
    }

    /**
     * @param argument Contact Profile Link Channel.
     */
    @JvmName("dkenciowkwwapyrb")
    public suspend fun channels(
        vararg
        argument: suspend ContactProfileLinkChannelArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContactProfileLinkChannelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.channels = mapped
    }

    /**
     * @param argument Contact Profile Link Channel.
     */
    @JvmName("urkbwpggpocnukoc")
    public suspend fun channels(argument: suspend ContactProfileLinkChannelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContactProfileLinkChannelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.channels = mapped
    }

    /**
     * @param values Contact Profile Link Channel.
     */
    @JvmName("byrhwxuomylxeurx")
    public suspend fun channels(vararg values: ContactProfileLinkChannelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channels = mapped
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("umqegjponpmsaisw")
    public suspend fun direction(`value`: Either<String, Direction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("woqtkjstnswdhnkc")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("wcevmxvddikkrurt")
    public fun direction(`value`: Direction) {
        val toBeMapped = Either.ofRight<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet.
     */
    @JvmName("icmudoblggertens")
    public suspend fun eirpdBW(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eirpdBW = mapped
    }

    /**
     * @param value Gain to noise temperature in db/K. It is the required G/T by the customer. Not used yet.
     */
    @JvmName("hjcxgncndukaohju")
    public suspend fun gainOverTemperature(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gainOverTemperature = mapped
    }

    /**
     * @param value Link name.
     */
    @JvmName("ophbrkhqesjgrvhi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("fppggwyvyjftgqhb")
    public suspend fun polarization(`value`: Either<String, Polarization>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polarization = mapped
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("gsptemhphsymtprm")
    public fun polarization(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Polarization>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polarization = mapped
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("ddgycipfmnigjajk")
    public fun polarization(`value`: Polarization) {
        val toBeMapped = Either.ofRight<String, Polarization>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polarization = mapped
    }

    internal fun build(): ContactProfileLinkArgs = ContactProfileLinkArgs(
        channels = channels ?: throw PulumiNullFieldException("channels"),
        direction = direction ?: throw PulumiNullFieldException("direction"),
        eirpdBW = eirpdBW,
        gainOverTemperature = gainOverTemperature,
        name = name ?: throw PulumiNullFieldException("name"),
        polarization = polarization ?: throw PulumiNullFieldException("polarization"),
    )
}
