@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ContactsPropertiesContactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The reference to the contact profile resource.
 * @property id Resource ID.
 */
public data class ContactsPropertiesContactProfileArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ContactsPropertiesContactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.ContactsPropertiesContactProfileArgs =
        com.pulumi.azurenative.orbital.inputs.ContactsPropertiesContactProfileArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactsPropertiesContactProfileArgs].
 */
@PulumiTagMarker
public class ContactsPropertiesContactProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("hjcdvqhaawpxnadp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ifonrxqyjqkxtuvx")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ContactsPropertiesContactProfileArgs = ContactsPropertiesContactProfileArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
