@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A reference to global communications site.
 * @property id Resource ID.
 */
public data class EdgeSitesPropertiesGlobalCommunicationsSiteArgs(
    public val id: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs> {
    override fun toJava():
        com.pulumi.azurenative.orbital.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs =
        com.pulumi.azurenative.orbital.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdgeSitesPropertiesGlobalCommunicationsSiteArgs].
 */
@PulumiTagMarker
public class EdgeSitesPropertiesGlobalCommunicationsSiteArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("hbcssqkvlcldhwwu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("sjhtliwvntvlehca")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): EdgeSitesPropertiesGlobalCommunicationsSiteArgs =
        EdgeSitesPropertiesGlobalCommunicationsSiteArgs(
            id = id ?: throw PulumiNullFieldException("id"),
        )
}
