@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesEdgeSiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A reference to an Microsoft.Orbital/edgeSites resource to route traffic for.
 * @property id Resource ID.
 */
public data class L2ConnectionsPropertiesEdgeSiteArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesEdgeSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesEdgeSiteArgs =
        com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesEdgeSiteArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [L2ConnectionsPropertiesEdgeSiteArgs].
 */
@PulumiTagMarker
public class L2ConnectionsPropertiesEdgeSiteArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ktkwraprokrueaes")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yovmelhatayvrrfu")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): L2ConnectionsPropertiesEdgeSiteArgs = L2ConnectionsPropertiesEdgeSiteArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
