@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesGroundStationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A reference to an Microsoft.Orbital/groundStations resource to route traffic for.
 * @property id Resource ID.
 */
public data class L2ConnectionsPropertiesGroundStationArgs(
    public val id: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesGroundStationArgs> {
    override fun toJava():
        com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesGroundStationArgs =
        com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesGroundStationArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [L2ConnectionsPropertiesGroundStationArgs].
 */
@PulumiTagMarker
public class L2ConnectionsPropertiesGroundStationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("jcwgpcaixirchhef")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bdpbffnbnedovnoh")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): L2ConnectionsPropertiesGroundStationArgs =
        L2ConnectionsPropertiesGroundStationArgs(
            id = id ?: throw PulumiNullFieldException("id"),
        )
}
