@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ListEdgeSiteL2ConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property edgeSiteName Edge site name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListEdgeSiteL2ConnectionsPlainArgs(
    public val edgeSiteName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ListEdgeSiteL2ConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.ListEdgeSiteL2ConnectionsPlainArgs =
        com.pulumi.azurenative.orbital.inputs.ListEdgeSiteL2ConnectionsPlainArgs.builder()
            .edgeSiteName(edgeSiteName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListEdgeSiteL2ConnectionsPlainArgs].
 */
@PulumiTagMarker
public class ListEdgeSiteL2ConnectionsPlainArgsBuilder internal constructor() {
    private var edgeSiteName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Edge site name.
     */
    @JvmName("ufahlyrgvnhtfosf")
    public suspend fun edgeSiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeSiteName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hhiqnntnwrweydyl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListEdgeSiteL2ConnectionsPlainArgs = ListEdgeSiteL2ConnectionsPlainArgs(
        edgeSiteName = edgeSiteName ?: throw PulumiNullFieldException("edgeSiteName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
