@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
 * @property autoTrackingConfiguration Auto-tracking configuration.
 * @property eventHubUri ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property links Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
 * @property location The geo-location where the resource lives
 * @property minimumElevationDegrees Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
 * @property minimumViableContactDuration Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
 * @property name The name of the resource
 * @property networkConfiguration Network configuration of customer virtual network.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property thirdPartyConfigurations Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetContactProfileResult(
    public val autoTrackingConfiguration: String? = null,
    public val eventHubUri: String? = null,
    public val id: String,
    public val links: List<ContactProfileLinkResponse>,
    public val location: String,
    public val minimumElevationDegrees: Double? = null,
    public val minimumViableContactDuration: String? = null,
    public val name: String,
    public val networkConfiguration: ContactProfilesPropertiesResponseNetworkConfiguration,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val thirdPartyConfigurations: List<ContactProfileThirdPartyConfigurationResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.GetContactProfileResult):
            GetContactProfileResult = GetContactProfileResult(
            autoTrackingConfiguration = javaType.autoTrackingConfiguration().map({ args0 ->
                args0
            }).orElse(null),
            eventHubUri = javaType.eventHubUri().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileLinkResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            minimumElevationDegrees = javaType.minimumElevationDegrees().map({ args0 -> args0 }).orElse(null),
            minimumViableContactDuration = javaType.minimumViableContactDuration().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            networkConfiguration = javaType.networkConfiguration().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfilesPropertiesResponseNetworkConfiguration.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            thirdPartyConfigurations = javaType.thirdPartyConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileThirdPartyConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
