@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for an API service call that lists the resource IDs of resources associated with another resource.
 * @property nextLink The URL to get the next set of results.
 * @property value A list of Azure Resource IDs.
 */
public data class ListGroundStationL2ConnectionsResult(
    public val nextLink: String,
    public val `value`: List<ResourceIdListResultResponseValue>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.ListGroundStationL2ConnectionsResult):
            ListGroundStationL2ConnectionsResult = ListGroundStationL2ConnectionsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.ResourceIdListResultResponseValue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
