@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ConnectionMonitorTest].
 */
@PulumiTagMarker
public class ConnectionMonitorTestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionMonitorTestArgs = ConnectionMonitorTestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionMonitorTestArgsBuilder.() -> Unit) {
        val builder = ConnectionMonitorTestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectionMonitorTest {
        val builtJavaResource =
            com.pulumi.azurenative.peering.ConnectionMonitorTest(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionMonitorTest(builtJavaResource)
    }
}

/**
 * The Connection Monitor Test class.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * ## Example Usage
 * ### Create or Update Connection Monitor Test
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionMonitorTest = new AzureNative.Peering.ConnectionMonitorTest("connectionMonitorTest", new()
 *     {
 *         ConnectionMonitorTestName = "connectionMonitorTestName",
 *         Destination = "Example Destination",
 *         DestinationPort = 443,
 *         PeeringServiceName = "peeringServiceName",
 *         ResourceGroupName = "rgName",
 *         SourceAgent = "Example Source Agent",
 *         TestFrequencyInSec = 30,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewConnectionMonitorTest(ctx, "connectionMonitorTest", &peering.ConnectionMonitorTestArgs{
 * 			ConnectionMonitorTestName: pulumi.String("connectionMonitorTestName"),
 * 			Destination:               pulumi.String("Example Destination"),
 * 			DestinationPort:           pulumi.Int(443),
 * 			PeeringServiceName:        pulumi.String("peeringServiceName"),
 * 			ResourceGroupName:         pulumi.String("rgName"),
 * 			SourceAgent:               pulumi.String("Example Source Agent"),
 * 			TestFrequencyInSec:        pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.ConnectionMonitorTest;
 * import com.pulumi.azurenative.peering.ConnectionMonitorTestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionMonitorTest = new ConnectionMonitorTest("connectionMonitorTest", ConnectionMonitorTestArgs.builder()
 *             .connectionMonitorTestName("connectionMonitorTestName")
 *             .destination("Example Destination")
 *             .destinationPort(443)
 *             .peeringServiceName("peeringServiceName")
 *             .resourceGroupName("rgName")
 *             .sourceAgent("Example Source Agent")
 *             .testFrequencyInSec(30)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:ConnectionMonitorTest connectionMonitorTestName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}
 * ```
 */
public class ConnectionMonitorTest internal constructor(
    override val javaResource: com.pulumi.azurenative.peering.ConnectionMonitorTest,
) : KotlinCustomResource(javaResource, ConnectionMonitorTestMapper) {
    /**
     * The Connection Monitor test destination
     */
    public val destination: Output<String>?
        get() = javaResource.destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Connection Monitor test destination port
     */
    public val destinationPort: Output<Int>?
        get() = javaResource.destinationPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flag that indicates if the Connection Monitor test is successful or not.
     */
    public val isTestSuccessful: Output<Boolean>
        get() = javaResource.isTestSuccessful().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The path representing the Connection Monitor test.
     */
    public val path: Output<List<String>>
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The Connection Monitor test source agent
     */
    public val sourceAgent: Output<String>?
        get() = javaResource.sourceAgent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Connection Monitor test frequency in seconds
     */
    public val testFrequencyInSec: Output<Int>?
        get() = javaResource.testFrequencyInSec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionMonitorTestMapper : ResourceMapper<ConnectionMonitorTest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.peering.ConnectionMonitorTest::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionMonitorTest =
        ConnectionMonitorTest(javaResource as com.pulumi.azurenative.peering.ConnectionMonitorTest)
}

/**
 * @see [ConnectionMonitorTest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionMonitorTest].
 */
public suspend fun connectionMonitorTest(
    name: String,
    block: suspend ConnectionMonitorTestResourceBuilder.() -> Unit,
): ConnectionMonitorTest {
    val builder = ConnectionMonitorTestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionMonitorTest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionMonitorTest(name: String): ConnectionMonitorTest {
    val builder = ConnectionMonitorTestResourceBuilder()
    builder.name(name)
    return builder.build()
}
