@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.BgpSessionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties that define a BGP session.
 * @property maxPrefixesAdvertisedV4 The maximum number of prefixes advertised over the IPv4 session.
 * @property maxPrefixesAdvertisedV6 The maximum number of prefixes advertised over the IPv6 session.
 * @property md5AuthenticationKey The MD5 authentication key of the session.
 * @property microsoftSessionIPv4Address The IPv4 session address on Microsoft's end.
 * @property microsoftSessionIPv6Address The IPv6 session address on Microsoft's end.
 * @property peerSessionIPv4Address The IPv4 session address on peer's end.
 * @property peerSessionIPv6Address The IPv6 session address on peer's end.
 * @property sessionPrefixV4 The IPv4 prefix that contains both ends' IPv4 addresses.
 * @property sessionPrefixV6 The IPv6 prefix that contains both ends' IPv6 addresses.
 */
public data class BgpSessionArgs(
    public val maxPrefixesAdvertisedV4: Output<Int>? = null,
    public val maxPrefixesAdvertisedV6: Output<Int>? = null,
    public val md5AuthenticationKey: Output<String>? = null,
    public val microsoftSessionIPv4Address: Output<String>? = null,
    public val microsoftSessionIPv6Address: Output<String>? = null,
    public val peerSessionIPv4Address: Output<String>? = null,
    public val peerSessionIPv6Address: Output<String>? = null,
    public val sessionPrefixV4: Output<String>? = null,
    public val sessionPrefixV6: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.BgpSessionArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.BgpSessionArgs =
        com.pulumi.azurenative.peering.inputs.BgpSessionArgs.builder()
            .maxPrefixesAdvertisedV4(maxPrefixesAdvertisedV4?.applyValue({ args0 -> args0 }))
            .maxPrefixesAdvertisedV6(maxPrefixesAdvertisedV6?.applyValue({ args0 -> args0 }))
            .md5AuthenticationKey(md5AuthenticationKey?.applyValue({ args0 -> args0 }))
            .microsoftSessionIPv4Address(microsoftSessionIPv4Address?.applyValue({ args0 -> args0 }))
            .microsoftSessionIPv6Address(microsoftSessionIPv6Address?.applyValue({ args0 -> args0 }))
            .peerSessionIPv4Address(peerSessionIPv4Address?.applyValue({ args0 -> args0 }))
            .peerSessionIPv6Address(peerSessionIPv6Address?.applyValue({ args0 -> args0 }))
            .sessionPrefixV4(sessionPrefixV4?.applyValue({ args0 -> args0 }))
            .sessionPrefixV6(sessionPrefixV6?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpSessionArgs].
 */
@PulumiTagMarker
public class BgpSessionArgsBuilder internal constructor() {
    private var maxPrefixesAdvertisedV4: Output<Int>? = null

    private var maxPrefixesAdvertisedV6: Output<Int>? = null

    private var md5AuthenticationKey: Output<String>? = null

    private var microsoftSessionIPv4Address: Output<String>? = null

    private var microsoftSessionIPv6Address: Output<String>? = null

    private var peerSessionIPv4Address: Output<String>? = null

    private var peerSessionIPv6Address: Output<String>? = null

    private var sessionPrefixV4: Output<String>? = null

    private var sessionPrefixV6: Output<String>? = null

    /**
     * @param value The maximum number of prefixes advertised over the IPv4 session.
     */
    @JvmName("hsreamwicuamsrsk")
    public suspend fun maxPrefixesAdvertisedV4(`value`: Output<Int>) {
        this.maxPrefixesAdvertisedV4 = value
    }

    /**
     * @param value The maximum number of prefixes advertised over the IPv6 session.
     */
    @JvmName("mptauptodmhxhgbj")
    public suspend fun maxPrefixesAdvertisedV6(`value`: Output<Int>) {
        this.maxPrefixesAdvertisedV6 = value
    }

    /**
     * @param value The MD5 authentication key of the session.
     */
    @JvmName("leyvskarsuvsmpdv")
    public suspend fun md5AuthenticationKey(`value`: Output<String>) {
        this.md5AuthenticationKey = value
    }

    /**
     * @param value The IPv4 session address on Microsoft's end.
     */
    @JvmName("fxdytrhcnpugvjty")
    public suspend fun microsoftSessionIPv4Address(`value`: Output<String>) {
        this.microsoftSessionIPv4Address = value
    }

    /**
     * @param value The IPv6 session address on Microsoft's end.
     */
    @JvmName("tppgucnxotnejrsd")
    public suspend fun microsoftSessionIPv6Address(`value`: Output<String>) {
        this.microsoftSessionIPv6Address = value
    }

    /**
     * @param value The IPv4 session address on peer's end.
     */
    @JvmName("efctgkdcwmqjfiaq")
    public suspend fun peerSessionIPv4Address(`value`: Output<String>) {
        this.peerSessionIPv4Address = value
    }

    /**
     * @param value The IPv6 session address on peer's end.
     */
    @JvmName("butgvlxlkrftwkpb")
    public suspend fun peerSessionIPv6Address(`value`: Output<String>) {
        this.peerSessionIPv6Address = value
    }

    /**
     * @param value The IPv4 prefix that contains both ends' IPv4 addresses.
     */
    @JvmName("ogfbpotifjagauaw")
    public suspend fun sessionPrefixV4(`value`: Output<String>) {
        this.sessionPrefixV4 = value
    }

    /**
     * @param value The IPv6 prefix that contains both ends' IPv6 addresses.
     */
    @JvmName("wabpidocrgylpxoi")
    public suspend fun sessionPrefixV6(`value`: Output<String>) {
        this.sessionPrefixV6 = value
    }

    /**
     * @param value The maximum number of prefixes advertised over the IPv4 session.
     */
    @JvmName("jqdgvhccaymbrlyw")
    public suspend fun maxPrefixesAdvertisedV4(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPrefixesAdvertisedV4 = mapped
    }

    /**
     * @param value The maximum number of prefixes advertised over the IPv6 session.
     */
    @JvmName("jwspgbrturtfjqkc")
    public suspend fun maxPrefixesAdvertisedV6(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPrefixesAdvertisedV6 = mapped
    }

    /**
     * @param value The MD5 authentication key of the session.
     */
    @JvmName("pekgrslhdbhdsmrq")
    public suspend fun md5AuthenticationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.md5AuthenticationKey = mapped
    }

    /**
     * @param value The IPv4 session address on Microsoft's end.
     */
    @JvmName("eerwwyuksxqyymbd")
    public suspend fun microsoftSessionIPv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftSessionIPv4Address = mapped
    }

    /**
     * @param value The IPv6 session address on Microsoft's end.
     */
    @JvmName("olreokbxorrgisuq")
    public suspend fun microsoftSessionIPv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftSessionIPv6Address = mapped
    }

    /**
     * @param value The IPv4 session address on peer's end.
     */
    @JvmName("juwvnxrtcyyxtdud")
    public suspend fun peerSessionIPv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerSessionIPv4Address = mapped
    }

    /**
     * @param value The IPv6 session address on peer's end.
     */
    @JvmName("gcmhfdcexlvlplta")
    public suspend fun peerSessionIPv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerSessionIPv6Address = mapped
    }

    /**
     * @param value The IPv4 prefix that contains both ends' IPv4 addresses.
     */
    @JvmName("ynwarrnbqimmxmll")
    public suspend fun sessionPrefixV4(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionPrefixV4 = mapped
    }

    /**
     * @param value The IPv6 prefix that contains both ends' IPv6 addresses.
     */
    @JvmName("gshvmsogqbcqgmtw")
    public suspend fun sessionPrefixV6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionPrefixV6 = mapped
    }

    internal fun build(): BgpSessionArgs = BgpSessionArgs(
        maxPrefixesAdvertisedV4 = maxPrefixesAdvertisedV4,
        maxPrefixesAdvertisedV6 = maxPrefixesAdvertisedV6,
        md5AuthenticationKey = md5AuthenticationKey,
        microsoftSessionIPv4Address = microsoftSessionIPv4Address,
        microsoftSessionIPv6Address = microsoftSessionIPv6Address,
        peerSessionIPv4Address = peerSessionIPv4Address,
        peerSessionIPv6Address = peerSessionIPv6Address,
        sessionPrefixV4 = sessionPrefixV4,
        sessionPrefixV6 = sessionPrefixV6,
    )
}
