@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.ContactDetailArgs.builder
import com.pulumi.azurenative.peering.kotlin.enums.Role
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The contact detail class.
 * @property email The e-mail address of the contact.
 * @property phone The phone number of the contact.
 * @property role The role of the contact.
 */
public data class ContactDetailArgs(
    public val email: Output<String>? = null,
    public val phone: Output<String>? = null,
    public val role: Output<Either<String, Role>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.ContactDetailArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.ContactDetailArgs =
        com.pulumi.azurenative.peering.inputs.ContactDetailArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .phone(phone?.applyValue({ args0 -> args0 }))
            .role(
                role?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContactDetailArgs].
 */
@PulumiTagMarker
public class ContactDetailArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var phone: Output<String>? = null

    private var role: Output<Either<String, Role>>? = null

    /**
     * @param value The e-mail address of the contact.
     */
    @JvmName("ykvpqcrqgoytxifw")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The phone number of the contact.
     */
    @JvmName("yxqbmkssjgajqmcv")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value The role of the contact.
     */
    @JvmName("kjpncrrbdnunwjvo")
    public suspend fun role(`value`: Output<Either<String, Role>>) {
        this.role = value
    }

    /**
     * @param value The e-mail address of the contact.
     */
    @JvmName("shskleafejormbca")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The phone number of the contact.
     */
    @JvmName("rmqakgtjsmqmicsv")
    public suspend fun phone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value The role of the contact.
     */
    @JvmName("npekgshcojwygeyi")
    public suspend fun role(`value`: Either<String, Role>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The role of the contact.
     */
    @JvmName("eluytdcpgwwqimij")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Role>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The role of the contact.
     */
    @JvmName("efvauvheiovqgyvy")
    public fun role(`value`: Role) {
        val toBeMapped = Either.ofRight<String, Role>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    internal fun build(): ContactDetailArgs = ContactDetailArgs(
        email = email,
        phone = phone,
        role = role,
    )
}
