@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Peering Service
 * @property id The ID of the resource.
 * @property location The location of the resource.
 * @property logAnalyticsWorkspaceProperties The Log Analytics Workspace Properties
 * @property name The name of the resource.
 * @property peeringServiceLocation The location (state/province) of the customer.
 * @property peeringServiceProvider The name of the service provider.
 * @property providerBackupPeeringLocation The backup peering (Microsoft/service provider) location to be used for customer traffic.
 * @property providerPrimaryPeeringLocation The primary peering (Microsoft/service provider) location to be used for customer traffic.
 * @property provisioningState The provisioning state of the resource.
 * @property sku The SKU that defines the type of the peering service.
 * @property tags The resource tags.
 * @property type The type of the resource.
 */
public data class GetPeeringServiceResult(
    public val id: String,
    public val location: String,
    public val logAnalyticsWorkspaceProperties: LogAnalyticsWorkspacePropertiesResponse? = null,
    public val name: String,
    public val peeringServiceLocation: String? = null,
    public val peeringServiceProvider: String? = null,
    public val providerBackupPeeringLocation: String? = null,
    public val providerPrimaryPeeringLocation: String? = null,
    public val provisioningState: String,
    public val sku: PeeringServiceSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.GetPeeringServiceResult):
            GetPeeringServiceResult = GetPeeringServiceResult(
            id = javaType.id(),
            location = javaType.location(),
            logAnalyticsWorkspaceProperties = javaType.logAnalyticsWorkspaceProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.LogAnalyticsWorkspacePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            peeringServiceLocation = javaType.peeringServiceLocation().map({ args0 -> args0 }).orElse(null),
            peeringServiceProvider = javaType.peeringServiceProvider().map({ args0 -> args0 }).orElse(null),
            providerBackupPeeringLocation = javaType.providerBackupPeeringLocation().map({ args0 ->
                args0
            }).orElse(null),
            providerPrimaryPeeringLocation = javaType.providerPrimaryPeeringLocation().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.PeeringServiceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
