@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The peering service prefix class.
 * @property errorMessage The error message for validation state
 * @property events The list of events for peering service prefix
 * @property id The ID of the resource.
 * @property learnedType The prefix learned type
 * @property name The name of the resource.
 * @property peeringServicePrefixKey The peering service prefix key
 * @property prefix The prefix from which your traffic originates.
 * @property prefixValidationState The prefix validation state
 * @property provisioningState The provisioning state of the resource.
 * @property type The type of the resource.
 */
public data class GetPrefixResult(
    public val errorMessage: String,
    public val events: List<PeeringServicePrefixEventResponse>,
    public val id: String,
    public val learnedType: String,
    public val name: String,
    public val peeringServicePrefixKey: String? = null,
    public val prefix: String? = null,
    public val prefixValidationState: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.GetPrefixResult):
            GetPrefixResult = GetPrefixResult(
            errorMessage = javaType.errorMessage(),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.PeeringServicePrefixEventResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            learnedType = javaType.learnedType(),
            name = javaType.name(),
            peeringServicePrefixKey = javaType.peeringServicePrefixKey().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            prefixValidationState = javaType.prefixValidationState(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
