@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin

import com.pulumi.azurenative.policyinsights.kotlin.outputs.AttestationEvidenceResponse
import com.pulumi.azurenative.policyinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.policyinsights.kotlin.outputs.AttestationEvidenceResponse.Companion.toKotlin as attestationEvidenceResponseToKotlin
import com.pulumi.azurenative.policyinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AttestationAtSubscription].
 */
@PulumiTagMarker
public class AttestationAtSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AttestationAtSubscriptionArgs = AttestationAtSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AttestationAtSubscriptionArgsBuilder.() -> Unit) {
        val builder = AttestationAtSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AttestationAtSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.policyinsights.AttestationAtSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AttestationAtSubscription(builtJavaResource)
    }
}

/**
 * An attestation resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create attestation at subscription scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attestationAtSubscription = new AzureNative.PolicyInsights.AttestationAtSubscription("attestationAtSubscription", new()
 *     {
 *         AttestationName = "790996e6-9871-4b1f-9cd9-ec42cd6ced1e",
 *         ComplianceState = "Compliant",
 *         PolicyAssignmentId = "/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/policyinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := policyinsights.NewAttestationAtSubscription(ctx, "attestationAtSubscription", &policyinsights.AttestationAtSubscriptionArgs{
 * 			AttestationName:    pulumi.String("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
 * 			ComplianceState:    pulumi.String("Compliant"),
 * 			PolicyAssignmentId: pulumi.String("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.policyinsights.AttestationAtSubscription;
 * import com.pulumi.azurenative.policyinsights.AttestationAtSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attestationAtSubscription = new AttestationAtSubscription("attestationAtSubscription", AttestationAtSubscriptionArgs.builder()
 *             .attestationName("790996e6-9871-4b1f-9cd9-ec42cd6ced1e")
 *             .complianceState("Compliant")
 *             .policyAssignmentId("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5")
 *             .build());
 *     }
 * }
 * ```
 * ### Create attestation at subscription scope with all properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attestationAtSubscription = new AzureNative.PolicyInsights.AttestationAtSubscription("attestationAtSubscription", new()
 *     {
 *         AssessmentDate = "2021-06-10T00:00:00Z",
 *         AttestationName = "790996e6-9871-4b1f-9cd9-ec42cd6ced1e",
 *         Comments = "This subscription has passed a security audit.",
 *         ComplianceState = "Compliant",
 *         Evidence = new[]
 *         {
 *             new AzureNative.PolicyInsights.Inputs.AttestationEvidenceArgs
 *             {
 *                 Description = "The results of the security audit.",
 *                 SourceUri = "https://gist.github.com/contoso/9573e238762c60166c090ae16b814011",
 *             },
 *         },
 *         ExpiresOn = "2021-06-15T00:00:00Z",
 *         Metadata =
 *         {
 *             { "departmentId", "NYC-MARKETING-1" },
 *         },
 *         Owner = "55a32e28-3aa5-4eea-9b5a-4cd85153b966",
 *         PolicyAssignmentId = "/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5",
 *         PolicyDefinitionReferenceId = "0b158b46-ff42-4799-8e39-08a5c23b4551",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/policyinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := policyinsights.NewAttestationAtSubscription(ctx, "attestationAtSubscription", &policyinsights.AttestationAtSubscriptionArgs{
 * 			AssessmentDate:  pulumi.String("2021-06-10T00:00:00Z"),
 * 			AttestationName: pulumi.String("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
 * 			Comments:        pulumi.String("This subscription has passed a security audit."),
 * 			ComplianceState: pulumi.String("Compliant"),
 * 			Evidence: []policyinsights.AttestationEvidenceArgs{
 * 				{
 * 					Description: pulumi.String("The results of the security audit."),
 * 					SourceUri:   pulumi.String("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
 * 				},
 * 			},
 * 			ExpiresOn: pulumi.String("2021-06-15T00:00:00Z"),
 * 			Metadata: pulumi.Any{
 * 				DepartmentId: "NYC-MARKETING-1",
 * 			},
 * 			Owner:                       pulumi.String("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
 * 			PolicyAssignmentId:          pulumi.String("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
 * 			PolicyDefinitionReferenceId: pulumi.String("0b158b46-ff42-4799-8e39-08a5c23b4551"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.policyinsights.AttestationAtSubscription;
 * import com.pulumi.azurenative.policyinsights.AttestationAtSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attestationAtSubscription = new AttestationAtSubscription("attestationAtSubscription", AttestationAtSubscriptionArgs.builder()
 *             .assessmentDate("2021-06-10T00:00:00Z")
 *             .attestationName("790996e6-9871-4b1f-9cd9-ec42cd6ced1e")
 *             .comments("This subscription has passed a security audit.")
 *             .complianceState("Compliant")
 *             .evidence(Map.ofEntries(
 *                 Map.entry("description", "The results of the security audit."),
 *                 Map.entry("sourceUri", "https://gist.github.com/contoso/9573e238762c60166c090ae16b814011")
 *             ))
 *             .expiresOn("2021-06-15T00:00:00Z")
 *             .metadata(Map.of("departmentId", "NYC-MARKETING-1"))
 *             .owner("55a32e28-3aa5-4eea-9b5a-4cd85153b966")
 *             .policyAssignmentId("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5")
 *             .policyDefinitionReferenceId("0b158b46-ff42-4799-8e39-08a5c23b4551")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:policyinsights:AttestationAtSubscription 790996e6-9871-4b1f-9cd9-ec42cd6ced1e /subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/attestations/{attestationName}
 * ```
 */
public class AttestationAtSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.policyinsights.AttestationAtSubscription,
) : KotlinCustomResource(javaResource, AttestationAtSubscriptionMapper) {
    /**
     * The time the evidence was assessed
     */
    public val assessmentDate: Output<String>?
        get() = javaResource.assessmentDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Comments describing why this attestation was created.
     */
    public val comments: Output<String>?
        get() = javaResource.comments().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The compliance state that should be set on the resource.
     */
    public val complianceState: Output<String>?
        get() = javaResource.complianceState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The evidence supporting the compliance state set in this attestation.
     */
    public val evidence: Output<List<AttestationEvidenceResponse>>?
        get() = javaResource.evidence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> attestationEvidenceResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The time the compliance state should expire.
     */
    public val expiresOn: Output<String>?
        get() = javaResource.expiresOn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time the compliance state was last changed in this attestation.
     */
    public val lastComplianceStateChangeAt: Output<String>
        get() = javaResource.lastComplianceStateChangeAt().applyValue({ args0 -> args0 })

    /**
     * Additional metadata for this attestation
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object ID.
     */
    public val owner: Output<String>?
        get() = javaResource.owner().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource ID of the policy assignment that the attestation is setting the state for.
     */
    public val policyAssignmentId: Output<String>
        get() = javaResource.policyAssignmentId().applyValue({ args0 -> args0 })

    /**
     * The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy assignment assigns a policy set definition the attestation can choose a definition within the set definition with this property or omit this and set the state for the entire set definition.
     */
    public val policyDefinitionReferenceId: Output<String>?
        get() = javaResource.policyDefinitionReferenceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the attestation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AttestationAtSubscriptionMapper : ResourceMapper<AttestationAtSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.policyinsights.AttestationAtSubscription::class == javaResource::class

    override fun map(javaResource: Resource): AttestationAtSubscription =
        AttestationAtSubscription(
            javaResource as
                com.pulumi.azurenative.policyinsights.AttestationAtSubscription,
        )
}

/**
 * @see [AttestationAtSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AttestationAtSubscription].
 */
public suspend fun attestationAtSubscription(
    name: String,
    block: suspend AttestationAtSubscriptionResourceBuilder.() -> Unit,
): AttestationAtSubscription {
    val builder = AttestationAtSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AttestationAtSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun attestationAtSubscription(name: String): AttestationAtSubscription {
    val builder = AttestationAtSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
