@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property remediationName The name of the remediation.
 * @property resourceId Resource ID.
 */
public data class GetRemediationAtResourcePlainArgs(
    public val remediationName: String,
    public val resourceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourcePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourcePlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourcePlainArgs.builder()
            .remediationName(remediationName.let({ args0 -> args0 }))
            .resourceId(resourceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRemediationAtResourcePlainArgs].
 */
@PulumiTagMarker
public class GetRemediationAtResourcePlainArgsBuilder internal constructor() {
    private var remediationName: String? = null

    private var resourceId: String? = null

    /**
     * @param value The name of the remediation.
     */
    @JvmName("uvxrlqrwxheuanxx")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ffjrmriitohpkycv")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    internal fun build(): GetRemediationAtResourcePlainArgs = GetRemediationAtResourcePlainArgs(
        remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
