@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property remediationName The name of the remediation.
 * @property resourceGroupName Resource group name.
 * @property top Maximum number of records to return.
 */
public data class ListRemediationDeploymentsAtResourceGroupPlainArgs(
    public val remediationName: String,
    public val resourceGroupName: String,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourceGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourceGroupPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourceGroupPlainArgs.builder()
            .remediationName(remediationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListRemediationDeploymentsAtResourceGroupPlainArgs].
 */
@PulumiTagMarker
public class ListRemediationDeploymentsAtResourceGroupPlainArgsBuilder internal constructor() {
    private var remediationName: String? = null

    private var resourceGroupName: String? = null

    private var top: Int? = null

    /**
     * @param value The name of the remediation.
     */
    @JvmName("shpqqbtoafogucvo")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    /**
     * @param value Resource group name.
     */
    @JvmName("jvbduduaiylsocvb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Maximum number of records to return.
     */
    @JvmName("ouitngscbiecfypm")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListRemediationDeploymentsAtResourceGroupPlainArgs =
        ListRemediationDeploymentsAtResourceGroupPlainArgs(
            remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            top = top,
        )
}
