@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The deployment status summary for all deployments created by the remediation.
 * @property failedDeployments The number of deployments required by the remediation that have failed.
 * @property successfulDeployments The number of deployments required by the remediation that have succeeded.
 * @property totalDeployments The number of deployments required by the remediation.
 */
public data class RemediationDeploymentSummaryResponse(
    public val failedDeployments: Int,
    public val successfulDeployments: Int,
    public val totalDeployments: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.RemediationDeploymentSummaryResponse):
            RemediationDeploymentSummaryResponse = RemediationDeploymentSummaryResponse(
            failedDeployments = javaType.failedDeployments(),
            successfulDeployments = javaType.successfulDeployments(),
            totalDeployments = javaType.totalDeployments(),
        )
    }
}
