@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Scenario specific error details.
 * @property info The scenario specific error details.
 * @property type The type of included error details.
 */
public data class TypedErrorInfoResponse(
    public val info: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.TypedErrorInfoResponse):
            TypedErrorInfoResponse = TypedErrorInfoResponse(
            info = javaType.info(),
            type = javaType.type(),
        )
    }
}
