@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.TenantConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Tenant configuration.
 * Azure REST API version: 2020-09-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * ## Example Usage
 * ### Create or update Tenant configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tenantConfiguration = new AzureNative.Portal.TenantConfiguration("tenantConfiguration", new()
 *     {
 *         ConfigurationName = "default",
 *         EnforcePrivateMarkdownStorage = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewTenantConfiguration(ctx, "tenantConfiguration", &portal.TenantConfigurationArgs{
 * 			ConfigurationName:             pulumi.String("default"),
 * 			EnforcePrivateMarkdownStorage: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.TenantConfiguration;
 * import com.pulumi.azurenative.portal.TenantConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tenantConfiguration = new TenantConfiguration("tenantConfiguration", TenantConfigurationArgs.builder()
 *             .configurationName("default")
 *             .enforcePrivateMarkdownStorage(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:TenantConfiguration default /providers/Microsoft.Portal/tenantConfigurations/{configurationName}
 * ```
 * @property configurationName The configuration name. Value must be 'default'
 * @property enforcePrivateMarkdownStorage When flag is set to true Markdown tile will require external storage configuration (URI). The inline content configuration will be prohibited.
 */
public data class TenantConfigurationArgs(
    public val configurationName: Output<String>? = null,
    public val enforcePrivateMarkdownStorage: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.TenantConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.TenantConfigurationArgs =
        com.pulumi.azurenative.portal.TenantConfigurationArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .enforcePrivateMarkdownStorage(
                enforcePrivateMarkdownStorage?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TenantConfigurationArgs].
 */
@PulumiTagMarker
public class TenantConfigurationArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var enforcePrivateMarkdownStorage: Output<Boolean>? = null

    /**
     * @param value The configuration name. Value must be 'default'
     */
    @JvmName("rechhpfwnxrojvst")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value When flag is set to true Markdown tile will require external storage configuration (URI). The inline content configuration will be prohibited.
     */
    @JvmName("pnjuayygyfpiqbew")
    public suspend fun enforcePrivateMarkdownStorage(`value`: Output<Boolean>) {
        this.enforcePrivateMarkdownStorage = value
    }

    /**
     * @param value The configuration name. Value must be 'default'
     */
    @JvmName("killsfltbsqtyrhk")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value When flag is set to true Markdown tile will require external storage configuration (URI). The inline content configuration will be prohibited.
     */
    @JvmName("uhlijeglvnmlsyrc")
    public suspend fun enforcePrivateMarkdownStorage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcePrivateMarkdownStorage = mapped
    }

    internal fun build(): TenantConfigurationArgs = TenantConfigurationArgs(
        configurationName = configurationName,
        enforcePrivateMarkdownStorage = enforcePrivateMarkdownStorage,
    )
}
