@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Tenant configuration.
 * @property enforcePrivateMarkdownStorage When flag is set to true Markdown tile will require external storage configuration (URI). The inline content configuration will be prohibited.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTenantConfigurationResult(
    public val enforcePrivateMarkdownStorage: Boolean? = null,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.GetTenantConfigurationResult):
            GetTenantConfigurationResult = GetTenantConfigurationResult(
            enforcePrivateMarkdownStorage = javaType.enforcePrivateMarkdownStorage().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
