@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The storage profile of the user settings.
 * @property diskSizeInGB Size of file share
 * @property fileShareName Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
 * @property storageAccountResourceId Full resource ID of storage account.
 */
public data class StorageProfileResponse(
    public val diskSizeInGB: Int? = null,
    public val fileShareName: String? = null,
    public val storageAccountResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.StorageProfileResponse):
            StorageProfileResponse = StorageProfileResponse(
            diskSizeInGB = javaType.diskSizeInGB().map({ args0 -> args0 }).orElse(null),
            fileShareName = javaType.fileShareName().map({ args0 -> args0 }).orElse(null),
            storageAccountResourceId = javaType.storageAccountResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
