@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin

import com.pulumi.azurenative.powerbidedicated.AutoScaleVCoreArgs.builder
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.AutoScaleVCoreSkuArgs
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.AutoScaleVCoreSkuArgsBuilder
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.SystemDataArgs
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.SystemDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an instance of an auto scale v-core resource.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create auto scale v-core
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var autoScaleVCore = new AzureNative.PowerBIDedicated.AutoScaleVCore("autoScaleVCore", new()
 *     {
 *         CapacityLimit = 10,
 *         CapacityObjectId = "a28f00bd-5330-4572-88f1-fa883e074785",
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         Sku = new AzureNative.PowerBIDedicated.Inputs.AutoScaleVCoreSkuArgs
 *         {
 *             Capacity = 0,
 *             Name = "AutoScale",
 *             Tier = "AutoScale",
 *         },
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *         VcoreName = "testvcore",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerbidedicated/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerbidedicated.NewAutoScaleVCore(ctx, "autoScaleVCore", &powerbidedicated.AutoScaleVCoreArgs{
 * 			CapacityLimit:     pulumi.Int(10),
 * 			CapacityObjectId:  pulumi.String("a28f00bd-5330-4572-88f1-fa883e074785"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			Sku: &powerbidedicated.AutoScaleVCoreSkuArgs{
 * 				Capacity: pulumi.Int(0),
 * 				Name:     pulumi.String("AutoScale"),
 * 				Tier:     pulumi.String("AutoScale"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 			VcoreName: pulumi.String("testvcore"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerbidedicated.AutoScaleVCore;
 * import com.pulumi.azurenative.powerbidedicated.AutoScaleVCoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var autoScaleVCore = new AutoScaleVCore("autoScaleVCore", AutoScaleVCoreArgs.builder()
 *             .capacityLimit(10)
 *             .capacityObjectId("a28f00bd-5330-4572-88f1-fa883e074785")
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 0),
 *                 Map.entry("name", "AutoScale"),
 *                 Map.entry("tier", "AutoScale")
 *             ))
 *             .tags(Map.of("testKey", "testValue"))
 *             .vcoreName("testvcore")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbidedicated:AutoScaleVCore testvcore /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}
 * ```
 * @property capacityLimit The maximum capacity of an auto scale v-core resource.
 * @property capacityObjectId The object ID of the capacity resource associated with the auto scale v-core resource.
 * @property location Location of the PowerBI Dedicated resource.
 * @property resourceGroupName The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
 * @property sku The SKU of the auto scale v-core resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Key-value pairs of additional resource provisioning properties.
 * @property vcoreName The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
 */
public data class AutoScaleVCoreArgs(
    public val capacityLimit: Output<Int>? = null,
    public val capacityObjectId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<AutoScaleVCoreSkuArgs>? = null,
    public val systemData: Output<SystemDataArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vcoreName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.AutoScaleVCoreArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbidedicated.AutoScaleVCoreArgs =
        com.pulumi.azurenative.powerbidedicated.AutoScaleVCoreArgs.builder()
            .capacityLimit(capacityLimit?.applyValue({ args0 -> args0 }))
            .capacityObjectId(capacityObjectId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .systemData(systemData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vcoreName(vcoreName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoScaleVCoreArgs].
 */
@PulumiTagMarker
public class AutoScaleVCoreArgsBuilder internal constructor() {
    private var capacityLimit: Output<Int>? = null

    private var capacityObjectId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<AutoScaleVCoreSkuArgs>? = null

    private var systemData: Output<SystemDataArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vcoreName: Output<String>? = null

    /**
     * @param value The maximum capacity of an auto scale v-core resource.
     */
    @JvmName("gjvxdxuetvgaxlea")
    public suspend fun capacityLimit(`value`: Output<Int>) {
        this.capacityLimit = value
    }

    /**
     * @param value The object ID of the capacity resource associated with the auto scale v-core resource.
     */
    @JvmName("hjcllhrcqmggifju")
    public suspend fun capacityObjectId(`value`: Output<String>) {
        this.capacityObjectId = value
    }

    /**
     * @param value Location of the PowerBI Dedicated resource.
     */
    @JvmName("ymhpovunmijnkqya")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("ysvydobouwxomylc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the auto scale v-core resource.
     */
    @JvmName("uioqfodlrmvyxrwh")
    public suspend fun sku(`value`: Output<AutoScaleVCoreSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Metadata pertaining to creation and last modification of the resource.
     */
    @JvmName("blsauwrixvtgsmot")
    public suspend fun systemData(`value`: Output<SystemDataArgs>) {
        this.systemData = value
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("irmymhhgelqryusc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("lolhlusdpawrtutr")
    public suspend fun vcoreName(`value`: Output<String>) {
        this.vcoreName = value
    }

    /**
     * @param value The maximum capacity of an auto scale v-core resource.
     */
    @JvmName("aqndnmyptppeshyk")
    public suspend fun capacityLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityLimit = mapped
    }

    /**
     * @param value The object ID of the capacity resource associated with the auto scale v-core resource.
     */
    @JvmName("hwfitvrqdmfvlqvp")
    public suspend fun capacityObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityObjectId = mapped
    }

    /**
     * @param value Location of the PowerBI Dedicated resource.
     */
    @JvmName("bwnspajllingpvnh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("fqrambsyseimbube")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the auto scale v-core resource.
     */
    @JvmName("chnkcyydkabjduwb")
    public suspend fun sku(`value`: AutoScaleVCoreSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the auto scale v-core resource.
     */
    @JvmName("hdpqvycpgfioyajm")
    public suspend fun sku(argument: suspend AutoScaleVCoreSkuArgsBuilder.() -> Unit) {
        val toBeMapped = AutoScaleVCoreSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Metadata pertaining to creation and last modification of the resource.
     */
    @JvmName("xtiqtravvoxqirqs")
    public suspend fun systemData(`value`: SystemDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemData = mapped
    }

    /**
     * @param argument Metadata pertaining to creation and last modification of the resource.
     */
    @JvmName("illqyyjrdsfbfpnx")
    public suspend fun systemData(argument: suspend SystemDataArgsBuilder.() -> Unit) {
        val toBeMapped = SystemDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemData = mapped
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("xvmjtxmyxlipymqf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("gauoaqexbqjvtsgs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("yscbslcoqxfgpiro")
    public suspend fun vcoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcoreName = mapped
    }

    internal fun build(): AutoScaleVCoreArgs = AutoScaleVCoreArgs(
        capacityLimit = capacityLimit,
        capacityObjectId = capacityObjectId,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        systemData = systemData,
        tags = tags,
        vcoreName = vcoreName,
    )
}
