@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin

import com.pulumi.azurenative.powerbidedicated.CapacityDetailsArgs.builder
import com.pulumi.azurenative.powerbidedicated.kotlin.enums.Mode
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.CapacitySkuArgs
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.CapacitySkuArgsBuilder
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.DedicatedCapacityAdministratorsArgs
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.DedicatedCapacityAdministratorsArgsBuilder
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.SystemDataArgs
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.SystemDataArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an instance of a Dedicated Capacity resource.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-10-01.
 * ## Example Usage
 * ### Create capacity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capacityDetails = new AzureNative.PowerBIDedicated.CapacityDetails("capacityDetails", new()
 *     {
 *         Administration = new AzureNative.PowerBIDedicated.Inputs.DedicatedCapacityAdministratorsArgs
 *         {
 *             Members = new[]
 *             {
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com",
 *             },
 *         },
 *         DedicatedCapacityName = "azsdktest",
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         Sku = new AzureNative.PowerBIDedicated.Inputs.CapacitySkuArgs
 *         {
 *             Name = "A1",
 *             Tier = "PBIE_Azure",
 *         },
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerbidedicated/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerbidedicated.NewCapacityDetails(ctx, "capacityDetails", &powerbidedicated.CapacityDetailsArgs{
 * 			Administration: &powerbidedicated.DedicatedCapacityAdministratorsArgs{
 * 				Members: pulumi.StringArray{
 * 					pulumi.String("azsdktest@microsoft.com"),
 * 					pulumi.String("azsdktest2@microsoft.com"),
 * 				},
 * 			},
 * 			DedicatedCapacityName: pulumi.String("azsdktest"),
 * 			Location:              pulumi.String("West US"),
 * 			ResourceGroupName:     pulumi.String("TestRG"),
 * 			Sku: &powerbidedicated.CapacitySkuArgs{
 * 				Name: pulumi.String("A1"),
 * 				Tier: pulumi.String("PBIE_Azure"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerbidedicated.CapacityDetails;
 * import com.pulumi.azurenative.powerbidedicated.CapacityDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capacityDetails = new CapacityDetails("capacityDetails", CapacityDetailsArgs.builder()
 *             .administration(Map.of("members",
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com"))
 *             .dedicatedCapacityName("azsdktest")
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "A1"),
 *                 Map.entry("tier", "PBIE_Azure")
 *             ))
 *             .tags(Map.of("testKey", "testValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbidedicated:CapacityDetails azsdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}
 * ```
 * @property administration A collection of Dedicated capacity administrators
 * @property dedicatedCapacityName The name of the Dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
 * @property location Location of the PowerBI Dedicated resource.
 * @property mode Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
 * @property resourceGroupName The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
 * @property sku The SKU of the PowerBI Dedicated capacity resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Key-value pairs of additional resource provisioning properties.
 */
public data class CapacityDetailsArgs(
    public val administration: Output<DedicatedCapacityAdministratorsArgs>? = null,
    public val dedicatedCapacityName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mode: Output<Either<String, Mode>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<CapacitySkuArgs>? = null,
    public val systemData: Output<SystemDataArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.CapacityDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbidedicated.CapacityDetailsArgs =
        com.pulumi.azurenative.powerbidedicated.CapacityDetailsArgs.builder()
            .administration(administration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dedicatedCapacityName(dedicatedCapacityName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .systemData(systemData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CapacityDetailsArgs].
 */
@PulumiTagMarker
public class CapacityDetailsArgsBuilder internal constructor() {
    private var administration: Output<DedicatedCapacityAdministratorsArgs>? = null

    private var dedicatedCapacityName: Output<String>? = null

    private var location: Output<String>? = null

    private var mode: Output<Either<String, Mode>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<CapacitySkuArgs>? = null

    private var systemData: Output<SystemDataArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A collection of Dedicated capacity administrators
     */
    @JvmName("uvipixtuvmchowac")
    public suspend fun administration(`value`: Output<DedicatedCapacityAdministratorsArgs>) {
        this.administration = value
    }

    /**
     * @param value The name of the Dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("omelhpwxmrsjicew")
    public suspend fun dedicatedCapacityName(`value`: Output<String>) {
        this.dedicatedCapacityName = value
    }

    /**
     * @param value Location of the PowerBI Dedicated resource.
     */
    @JvmName("wphicxcmhknhxusr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
     */
    @JvmName("iqmnnxfrsharqtrl")
    public suspend fun mode(`value`: Output<Either<String, Mode>>) {
        this.mode = value
    }

    /**
     * @param value The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("wxvinwptlglbmgxp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the PowerBI Dedicated capacity resource.
     */
    @JvmName("sppycysjngiwuogn")
    public suspend fun sku(`value`: Output<CapacitySkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Metadata pertaining to creation and last modification of the resource.
     */
    @JvmName("yhaagyyhyydorxqm")
    public suspend fun systemData(`value`: Output<SystemDataArgs>) {
        this.systemData = value
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("tpxobliybmrmlmih")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A collection of Dedicated capacity administrators
     */
    @JvmName("oqtxpjpitoebiwso")
    public suspend fun administration(`value`: DedicatedCapacityAdministratorsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administration = mapped
    }

    /**
     * @param argument A collection of Dedicated capacity administrators
     */
    @JvmName("bvwmqinfmyjkgcfk")
    public suspend
    fun administration(argument: suspend DedicatedCapacityAdministratorsArgsBuilder.() -> Unit) {
        val toBeMapped = DedicatedCapacityAdministratorsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administration = mapped
    }

    /**
     * @param value The name of the Dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("hgehxedukgifnswj")
    public suspend fun dedicatedCapacityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedCapacityName = mapped
    }

    /**
     * @param value Location of the PowerBI Dedicated resource.
     */
    @JvmName("mlialcwgiqlttbhr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
     */
    @JvmName("xfxsbyuwsvjreknf")
    public suspend fun mode(`value`: Either<String, Mode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
     */
    @JvmName("rrxscdfxdwdsbdav")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
     */
    @JvmName("wiwrmmrcxmnlsyus")
    public fun mode(`value`: Mode) {
        val toBeMapped = Either.ofRight<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("thotffcijaiylvsn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the PowerBI Dedicated capacity resource.
     */
    @JvmName("keetvynyqnqkedud")
    public suspend fun sku(`value`: CapacitySkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the PowerBI Dedicated capacity resource.
     */
    @JvmName("ysmqsdmllekukdtl")
    public suspend fun sku(argument: suspend CapacitySkuArgsBuilder.() -> Unit) {
        val toBeMapped = CapacitySkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Metadata pertaining to creation and last modification of the resource.
     */
    @JvmName("sgacnvdmxvqlegnd")
    public suspend fun systemData(`value`: SystemDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemData = mapped
    }

    /**
     * @param argument Metadata pertaining to creation and last modification of the resource.
     */
    @JvmName("gwbakosagnocthny")
    public suspend fun systemData(argument: suspend SystemDataArgsBuilder.() -> Unit) {
        val toBeMapped = SystemDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemData = mapped
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("eahovavepxkerwkx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("ymlqldbxvhjingmm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CapacityDetailsArgs = CapacityDetailsArgs(
        administration = administration,
        dedicatedCapacityName = dedicatedCapacityName,
        location = location,
        mode = mode,
        resourceGroupName = resourceGroupName,
        sku = sku,
        systemData = systemData,
        tags = tags,
    )
}
