@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin

import com.pulumi.azurenative.powerbidedicated.PowerbidedicatedFunctions.getAutoScaleVCorePlain
import com.pulumi.azurenative.powerbidedicated.PowerbidedicatedFunctions.getCapacityDetailsPlain
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.GetAutoScaleVCorePlainArgs
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.GetAutoScaleVCorePlainArgsBuilder
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.GetCapacityDetailsPlainArgs
import com.pulumi.azurenative.powerbidedicated.kotlin.inputs.GetCapacityDetailsPlainArgsBuilder
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.GetAutoScaleVCoreResult
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.GetCapacityDetailsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.GetAutoScaleVCoreResult.Companion.toKotlin as getAutoScaleVCoreResultToKotlin
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.GetCapacityDetailsResult.Companion.toKotlin as getCapacityDetailsResultToKotlin

public object PowerbidedicatedFunctions {
    /**
     * Gets details about the specified auto scale v-core.
     * Azure REST API version: 2021-01-01.
     * @param argument null
     * @return Represents an instance of an auto scale v-core resource.
     */
    public suspend fun getAutoScaleVCore(argument: GetAutoScaleVCorePlainArgs):
        GetAutoScaleVCoreResult =
        getAutoScaleVCoreResultToKotlin(getAutoScaleVCorePlain(argument.toJava()).await())

    /**
     * @see [getAutoScaleVCore].
     * @param resourceGroupName The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     * @param vcoreName The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
     * @return Represents an instance of an auto scale v-core resource.
     */
    public suspend fun getAutoScaleVCore(resourceGroupName: String, vcoreName: String):
        GetAutoScaleVCoreResult {
        val argument = GetAutoScaleVCorePlainArgs(
            resourceGroupName = resourceGroupName,
            vcoreName = vcoreName,
        )
        return getAutoScaleVCoreResultToKotlin(getAutoScaleVCorePlain(argument.toJava()).await())
    }

    /**
     * @see [getAutoScaleVCore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerbidedicated&#46;kotlin&#46;inputs&#46;GetAutoScaleVCorePlainArgs].
     * @return Represents an instance of an auto scale v-core resource.
     */
    public suspend
    fun getAutoScaleVCore(argument: suspend GetAutoScaleVCorePlainArgsBuilder.() -> Unit):
        GetAutoScaleVCoreResult {
        val builder = GetAutoScaleVCorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutoScaleVCoreResultToKotlin(getAutoScaleVCorePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details about the specified dedicated capacity.
     * Azure REST API version: 2021-01-01.
     * Other available API versions: 2017-10-01.
     * @param argument null
     * @return Represents an instance of a Dedicated Capacity resource.
     */
    public suspend fun getCapacityDetails(argument: GetCapacityDetailsPlainArgs):
        GetCapacityDetailsResult =
        getCapacityDetailsResultToKotlin(getCapacityDetailsPlain(argument.toJava()).await())

    /**
     * @see [getCapacityDetails].
     * @param dedicatedCapacityName The name of the dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
     * @param resourceGroupName The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     * @return Represents an instance of a Dedicated Capacity resource.
     */
    public suspend fun getCapacityDetails(dedicatedCapacityName: String, resourceGroupName: String):
        GetCapacityDetailsResult {
        val argument = GetCapacityDetailsPlainArgs(
            dedicatedCapacityName = dedicatedCapacityName,
            resourceGroupName = resourceGroupName,
        )
        return getCapacityDetailsResultToKotlin(getCapacityDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCapacityDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerbidedicated&#46;kotlin&#46;inputs&#46;GetCapacityDetailsPlainArgs].
     * @return Represents an instance of a Dedicated Capacity resource.
     */
    public suspend
    fun getCapacityDetails(argument: suspend GetCapacityDetailsPlainArgsBuilder.() -> Unit):
        GetCapacityDetailsResult {
        val builder = GetCapacityDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCapacityDetailsResultToKotlin(getCapacityDetailsPlain(builtArgument.toJava()).await())
    }
}
