@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.inputs

import com.pulumi.azurenative.powerbidedicated.inputs.DedicatedCapacityAdministratorsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An array of administrator user identities
 * @property members An array of administrator user identities.
 */
public data class DedicatedCapacityAdministratorsArgs(
    public val members: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.inputs.DedicatedCapacityAdministratorsArgs> {
    override fun toJava():
        com.pulumi.azurenative.powerbidedicated.inputs.DedicatedCapacityAdministratorsArgs =
        com.pulumi.azurenative.powerbidedicated.inputs.DedicatedCapacityAdministratorsArgs.builder()
            .members(members?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DedicatedCapacityAdministratorsArgs].
 */
@PulumiTagMarker
public class DedicatedCapacityAdministratorsArgsBuilder internal constructor() {
    private var members: Output<List<String>>? = null

    /**
     * @param value An array of administrator user identities.
     */
    @JvmName("khkcfwdscuefmmqb")
    public suspend fun members(`value`: Output<List<String>>) {
        this.members = value
    }

    @JvmName("ftnwuslpedwqqndi")
    public suspend fun members(vararg values: Output<String>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values An array of administrator user identities.
     */
    @JvmName("irjfmtjtahheysdw")
    public suspend fun members(values: List<Output<String>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value An array of administrator user identities.
     */
    @JvmName("erkgtegwasqojnan")
    public suspend fun members(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param values An array of administrator user identities.
     */
    @JvmName("unvnkltwfdixnwit")
    public suspend fun members(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    internal fun build(): DedicatedCapacityAdministratorsArgs = DedicatedCapacityAdministratorsArgs(
        members = members,
    )
}
