@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings concerning key vault encryption for a configuration store.
 * @property id Uri of KeyVault
 * @property key Identity of the secret that includes name and version.
 */
public data class KeyVaultPropertiesArgs(
    public val id: Output<String>? = null,
    public val key: Output<KeyPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.powerplatform.inputs.KeyVaultPropertiesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var key: Output<KeyPropertiesArgs>? = null

    /**
     * @param value Uri of KeyVault
     */
    @JvmName("iyceaqmwdxqlubod")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Identity of the secret that includes name and version.
     */
    @JvmName("kluaykxttxsbbhsj")
    public suspend fun key(`value`: Output<KeyPropertiesArgs>) {
        this.key = value
    }

    /**
     * @param value Uri of KeyVault
     */
    @JvmName("lwvukdowscmuybql")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Identity of the secret that includes name and version.
     */
    @JvmName("kvdnmlopvgqrmaxe")
    public suspend fun key(`value`: KeyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param argument Identity of the secret that includes name and version.
     */
    @JvmName("mywbdwkxvpasrqmo")
    public suspend fun key(argument: suspend KeyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.key = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        id = id,
        key = key,
    )
}
