@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the EnterprisePolicy.
 * @property encryption The encryption settings for a configuration store.
 * @property healthStatus The health status of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the EnterprisePolicy.
 * @property kind The kind (type) of Enterprise Policy.
 * @property location The geo-location where the resource lives
 * @property lockbox Settings concerning lockbox.
 * @property name The name of the resource
 * @property networkInjection Settings concerning network injection.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property systemId The internally assigned unique identifier of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEnterprisePolicyResult(
    public val encryption: PropertiesResponseEncryption? = null,
    public val healthStatus: String? = null,
    public val id: String,
    public val identity: EnterprisePolicyIdentityResponse? = null,
    public val kind: String,
    public val location: String,
    public val lockbox: PropertiesResponseLockbox? = null,
    public val name: String,
    public val networkInjection: PropertiesResponseNetworkInjection? = null,
    public val systemData: SystemDataResponse,
    public val systemId: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.outputs.GetEnterprisePolicyResult):
            GetEnterprisePolicyResult = GetEnterprisePolicyResult(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseEncryption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.EnterprisePolicyIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location(),
            lockbox = javaType.lockbox().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseLockbox.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkInjection = javaType.networkInjection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseNetworkInjection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.powerplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            systemId = javaType.systemId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
