@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A list of private link resources
 * @property nextLink Next page link if any.
 * @property value Array of virtual networks.
 */
public data class VirtualNetworkPropertiesListResponse(
    public val nextLink: String? = null,
    public val `value`: List<VirtualNetworkPropertiesResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.outputs.VirtualNetworkPropertiesListResponse):
            VirtualNetworkPropertiesListResponse = VirtualNetworkPropertiesListResponse(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.VirtualNetworkPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
